<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


	Route::group(
	[
		'prefix' => LaravelLocalization::setLocale(),
	],
	function()
	{
		

	Route::group(['middleware' => 'auth'], function () {
	Route::group(['middleware' => 'admin'], function () {

		Route::group(['prefix' => '/admin'], function () {
		
			Route::get('setting','Admin\SettingController@create');
			Route::post('setting','Admin\SettingController@store');

			Route::get('home','Admin\HomeController@index');
			Route::get('reports_browsing','Admin\ReportsController@GetBrowsingInfo');
			Route::get('reports_browsing/{id}/u/{user_name}','Admin\ReportsController@getUserBrowseInfo');
			Route::get('reports_browsing/{id}/delete','Admin\ReportsController@delete_reports');

			Route::get('file/{id}/delete','Admin\SettingController@delete_external_file');

			Route::get('wating_lists','Admin\WatingListController@index');
			Route::get('wating_list/search','Admin\WatingListController@saarch');
			Route::get('wating_lists/export','Admin\WatingListController@ExportExelSheet');
			Route::get('wating_lists/{id}/delete','Admin\WatingListController@destroy');

			Route::resource('users','Admin\UsersController');
			Route::get('users_export','Admin\UsersController@ExportExelSheet');
			Route::get('users/{id}/delete','Admin\UsersController@destroy');
			Route::DELETE('users_delete_all','Admin\UsersController@destroyAll');
			

			Route::resource('sliders','Admin\SliderController');
			Route::get('sliders/{id}/delete','Admin\SliderController@destroy');
			Route::DELETE('sliders_delete_all','Admin\SliderController@destroySelected');

			Route::resource('services','Admin\CategoriesController');
			Route::get('services/{id}/delete','Admin\CategoriesController@destroy');
			Route::get('services_export','Admin\CategoriesController@ExportExelSheet');
			Route::DELETE('services_delete_all','Admin\CategoriesController@destroyAll');
			Route::get('services_category/{category_id}/create','Admin\ServicesCategoryController@create');
			Route::post('services_category/{category_id}','Admin\ServicesCategoryController@store');
			Route::get('services_category/{category_id}','Admin\ServicesCategoryController@index');
			Route::get('services_category/{category_id}/edit','Admin\ServicesCategoryController@edit');
			Route::PUT('services_category/{category_id}',['uses'=>'Admin\ServicesCategoryController@update','as'=>'services_category.update']);


			Route::resource('gallery','Admin\TestmonialsController');
			Route::get('gallery/{id}/delete','Admin\TestmonialsController@destroy');
			Route::DELETE('gallery_delete_all','Admin\TestmonialsController@destroyAll');
			// Route::get('testmonials_export','Admin\TestmonialsController@ExportExelSheet');

			Route::resource('pages','Admin\PagesController');
			Route::get('pages/{id}/delete','Admin\PagesController@destroy');
			Route::DELETE('pages_delete_all','Admin\PagesController@destroyAll');


			Route::resource('ads','Admin\AdsController');
			Route::get('banned_ads','Admin\AdsController@bannedAds');
			Route::get('banned_ads/{ad_id}/{status}','Admin\AdsController@banneAdd');
			Route::get('ads/{id}/image/delete','Admin\AdsController@DestroyImage');
			Route::get('ads/{id}/delete','Admin\AdsController@destroy');
			Route::DELETE('ads_delete_all','Admin\AdsController@destroyAll');


			Route::get('aboutus','Admin\AboutusController@create');
			Route::post('aboutus','Admin\AboutusController@save');

			Route::resource('blogs','Admin\BlogsController');
			Route::get('blogs/{id}/delete','Admin\BlogsController@destroy');
			Route::get('blogs_search','Admin\BlogsController@search');			
			Route::get('blogs_export','Admin\BlogsController@ExportExelSheet');

			Route::get('contactus','Admin\ContactUsController@list');
			Route::get('contactus/{id}/delete','Admin\ContactUsController@destroy');
			Route::DELETE('contactus_delete_all','Admin\ContactUsController@destroyAll');
			Route::get('mail/reply/{contact_id}','Admin\ContactUsController@GetReply');
		    Route::post('contact_us/reply','Admin\ContactUsController@PostReply');

			Route::resource('countries','Admin\CountriesController');
			Route::get('countries/{id}/delete','Admin\CountriesController@destroy');
			Route::DELETE('countries_delete_all','Admin\CountriesController@destroySelected');

			Route::get('cities/{country_id}','Admin\CitiesController@index');
			Route::get('cities/{country_id}/create','Admin\CitiesController@create');
			Route::post('cities/{country_id}','Admin\CitiesController@store');
			Route::get('cities/{id}/delete','Admin\CitiesController@destroy');
			Route::DELETE('cities_delete_all','Admin\CitiesController@destroySelected');



			Route::get('places/{country_id}','Admin\PlacesController@index');
			Route::get('places/{country_id}/create','Admin\PlacesController@create');
			Route::post('places/{country_id}','Admin\PlacesController@store');
			Route::get('places/{id}/delete','Admin\PlacesController@destroy');
			Route::DELETE('places_delete_all','Admin\PlacesController@destroySelected');


			
			Route::resource('events','Admin\Eventsontroller');
			Route::get('events/{id}/delete','Admin\Eventsontroller@destroy');
			Route::DELETE('events_delete_all','Admin\Eventsontroller@destroySelected');

			Route::resource('groups','Admin\GroupsController');
			Route::get('groups/{id}/delete','Admin\GroupsController@destroy');
			Route::DELETE('groups_delete_all','Admin\GroupsController@destroySelected');
			
			Route::resource('pro_categories','Admin\ReasonsReportController');
			Route::get('pro_categories/{id}/delete','Admin\ReasonsReportController@destroy');
			Route::DELETE('pro_categories_delete_all','Admin\ReasonsReportController@destroySelected');

			Route::resource('news','Admin\BlogsController');
    		Route::get('news/{id}/delete','Admin\BlogsController@destroy');
			Route::DELETE('news_delete_all','Admin\BlogsController@destroySelected');

			Route::resource('jobs','Admin\JobsController');
    		Route::get('jobs/{id}/delete','Admin\JobsController@destroy');
			Route::DELETE('jobs_delete_all','Admin\JobsController@destroySelected');


			Route::get('mail/subscripers','Admin\SubscribersController@index');
			Route::get('subscripers/{id}/delete','Admin\SubscribersController@destroy');
			Route::DELETE('subscripers_delete_all','Admin\SubscribersController@destroyAll');



			Route::get('sitemap/create','Admin\SitemapGeneratorController@create');
			Route::post('sitemap','Admin\SitemapGeneratorController@store');
		});


	});
	});
		Route::get('logout','Auth\LoginController@logout');
	});

	//site routes 
	

Route::get('/','Front\CoomingSoonController@index');
Route::post('user/waiting','Front\WatingListController@setInList');

	Route::group(
	[
		'prefix' => LaravelLocalization::setLocale(),
	],
	function()
	{
		Route::get('/','Front\HomeController@index');
		Route::get('/serivce/{service_id}/{service_name}','Front\HomeController@service');
		// Route::get('/page/{id}/{url?}','Front\HomeController@page');
		Route::get('/news','Front\HomeController@news');
		Route::get('/article/{article_id}','Front\HomeController@BlogShow');
		Route::get('/contact','Front\HomeController@contact');
		Route::post('contactus','Front\ContctUsController@posttSendAsk');
		Route::get('/projects','Front\HomeController@projects');
		Route::get('/projects/{id}/{name?}','Front\HomeController@projectShow');
		Route::get('/job/{id}/{name?}','Front\HomeController@jobDetails');
		Route::get('/about_us','Front\HomeController@about_us');
		Route::post('subscribe','Front\SubscribersController@sensSubscrip');




	Auth::routes();
	Route::get('/register','Auth\CustomAuthController@Getsignup')->name('register');
	Route::get('/admin','Auth\CustomAuthController@adminLogin');
	});


