@extends('panel.layouts.layout')
@section('content')
	  <!-- =====================================
        ==== Start Home-content  -->

        <section class="users-list">
            <div class="container-fluid">

                <div class="row">
                    <div class="col-md-11">
                        <div class="wel-text">
                            <div class="path">
                                <a href="{{ url('admin/home') }}">@lang('home.home')</a><span>/</span>@lang('home.full_report') 
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-1">
                        <div class="dropdown">
                          <button class="btn btn-defualt dropdown-toggle" type="button" data-toggle="dropdown">@lang('home.links')
                              <span class="caret"></span></button>
                              <ul class="dropdown-menu" style="padding: 10px">
                                <li  style="padding: 10px"><a href="{{ URL::to('ar/admin/setting') }}"><i class="icon-gear"></i>@lang('home.general_settings')</a></li>
                                <li  style="padding: 5px"><a href="{{ URL::to('ar/admin/reports_browsing') }}"><i class="icon-copy"></i> @lang('home.full_report')</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                @if(Session::has('success'))
                    <div class="alert alert-success alert-dismissible">
                        <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>{{ Session::get('success') }}
                    </div>
                @endif
                <table class="block-table">
                    <tbody>
                        <tr>
                            <th>@lang('home.user')</th>  
                            <th>@lang('home.process')</th>
                            <th>@lang('home.action')</th>
                            <th>@lang('home.since')</th>
                            <th>@lang('home.ip')</th>
                            <th>@lang('home.location')</th>
                            <th>@lang('home.browser')</th>
                            <th>@lang('home.delete')</th>

                        </tr>
                        @foreach($reports as $user)            
                        <tr>
                            <td>
                                <div class="img"><img src="{{ asset('/').@$user->user->image}}" alt="{{ @$user->fname.' '.$user->lname }}"></div> <span>{{ @$user->fname.' '.$user->lname }}</span>
                            </td>
                           <td>@include('dashboard.reports.user_reports_model')</td>

                            <td>{{ @$user->text }}</td>
                            <td>{{@Carbon\Carbon::parse($user->created_at)->diffForHumans()}}</td>
                            <td>{{ @$user->ip }}</td>
                            <td>{{ @$user->location }}</td>
                           <td>{{ @$user->browser }}</td>
                            <td>
                                <a class="btn btn-danger btn-sm" href="{{URL::to('ar/')}}/admin/reports_browsing/{{@$user->id}}/delete"><li class="icon-trash"></li></a>
                            </td>   
                        </tr>
                        @endforeach

                    </tbody>
                </table>
            </div>
        </section>
@stop