@extends('panel.layouts.layout')
@section('content')
<!-- =====================================
==== Start settings  -->
<br>
<section class="settings">
    <div class="container-fluid">
     <div class="row">
        <div class="col-md-11">
            <div class="wel-text">
                <div class="path">
                 <ul>
                    <a href="{{ url('admin/home') }}">@lang('home.home')</a>
                    <span>/</span>
                    <a href="{{ URL::to('admin/services') }}"><i class="icon-home2 position-left"></i> @lang('home.services')</a>
                    <span>/</span>
                    @lang('home.new_service')
                </ul>
            </div>
        </div>
    </div>

    <div class="col-md-1">
        <div class="dropdown">
          <button class="btn btn-defualt dropdown-toggle" type="button" data-toggle="dropdown">@lang('home.links')
              <span class="caret"></span></button>
              <ul class="dropdown-menu" style="padding: 10px">
                <li  style="padding: 10px"><a href="{{ URL::to('ar/admin/setting') }}"><i class="icon-gear"></i>@lang('home.general_settings')</a></li>
                <li  style="padding: 5px"><a href="{{ URL::to('ar/admin/reports_browsing') }}"><i class="icon-copy"></i> @lang('home.full_report')</a></li>
            </ul>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-12 col-md-6">
        <div class="item">
            <div class="head">
                <h5> @lang('home.new_service')</h5>
            </div>
            <form class="form-horizontal form-validate-jquery" method="POST" action="{{ URL::to('/admin/services') }}" enctype='multipart/form-data'>

                @if ($errors->any())
                @foreach ($errors->all() as $error)
                <div class="alert alert-danger alert-dismissible" >
                    <a href="#" class="close" data-dismiss="alert" aria-label="close" style="right: 5px;">&times;</a>{{ $error }}
                </div>
                @endforeach
                @endif
                @if(Session::has('success'))
                <div class="alert alert-success alert-dismissible">
                    <a href="#" class="close" data-dismiss="alert" aria-label="close" style="right: 5px;">&times;</a>{{ Session::get('success') }}
                </div>
                @endif
                @csrf
                <!-- choose type category input -->
                <div class="form-group">
                    <label class="control-label col-lg-3">@lang('home.choose_type') <span class="text-danger" title="@lang('home.required')">*</span></label>
                    <div class="col-lg-12"> 
                        <select name="category_type" class="form-control" id="chose_type" >
                            <option value="main">@lang('home.main_service')</option>
                            <option value="sub">@lang('home.sub_service')</option>

                        </select>
                    </div>
                </div>
                <!-- /choose type category input -->  
                <!-- choose category input -->
                <div class="form-group" id="main_category">
                    <label class="control-label col-lg-3">@lang('home.main_categories') <span class="text-danger" title="@lang('home.required')">*</span></label>
                    <div class="col-lg-12"> 
                        <select name="parent_id" class="form-control" >
                            <option value="">@lang('home.select_one')</option>
                            @foreach($categories as $cat)
                            <option value="{{@$cat->id}}">
                                {{@$cat->category_translation->name}}

                            </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                @include('panel.categories.form')

                <button type="submit" class="btn btn-primary">@lang('home.save') <i class="icon-arrow-left13 position-right"></i></button>

            </form>
        </div>
    </div>
    
</div>
</div>
</section>
@stop
@section('jsCode')
    <script>
    $('#main_category').hide();

    $('#chose_type').on('change',function(){
        if($('#chose_type').val() == 'sub'){
        $('#main_category').show();
        }else{
            $('#main_category').hide();
        }
    });
    </script>
@stop
