@extends('front.layouts.main')
@section('meta_tags')
       <title>{{ @$project->translations->where('lang_id',$active_lang->id)->first()->title }}| {{@$setting->translation->title}}</title>
    <meta name='description' itemprop='description' content='{!! @$info->translation->content!!}' />
    <meta name='keywords' content='{!!@$setting->meta_tags!!},{!!@$info->translation->title !!},{!!@$info->mission !!},{!!@$info->goals!!}' />
    <meta property="og:description"content="{{ @$info->translation->content }}" />
    <meta property="og:title"content="{{ @$project->tr }} | {{@$setting->translation->title}} " />
    <meta property="og:url"content="{{URL::to('/news')}}" />
    <meta property="og:site_name"content="{{@$setting->translation->title}}" />
    <meta property="og:image" content="{{URL::to('/').@$setting->logo}}">

    <meta name="twitter:card"content="summary" />
    <meta name="twitter:title"content="{{ @$project->tr }}| {{@$setting->translation->title}}" />
    <meta name="twitter:site"content="@wait" />
@stop
@section('content')

 <!--inner-header-->
    <section class="inner-header section-padding">
        <div class="container">
            <div class="section-head text-center">
                <h2> @lang('home.details')</h2>
            </div>
        </div>
    </section>
    <!--inner-header-->
    <!--Contents-->
    <main>
        <!-- --------------------- start about ---------------------- -->
        <section class="about section-padding">
            <div class="container">
                <!-- <div class="section-head text-center">
                    <h2>من نحن</h2>
                </div> -->

                <div class="row">

                    <div class="col-lg-12">
                        <div class="info">
                            <h3>{{ @$project->translations->where('lang_id',$active_lang->id)->first()->title }}</h3>
                            <div class="text">
                              
                              {{ @$project->translations->where('lang_id',$active_lang->id)->first()->content }}
                            </div>
                                                <!-- <a href="#" class="butn"><span>المزيد</span></a> -->
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- --------------------- start gallery pg ---------------------- -->
        <section class="portfolio gallery-pg section-padding">
            <div class="container">
                <div class="col-lg-5">
                    <div class="section-head side">
                        <h2>صور المشروع</h2>
                    </div>
                </div>
                <div class="content">
                    <!-- our projects -->
                    <div class="row content wow fadeInUp">
                        @foreach($project->galleries as $ga_key =>$image)
                        <div class="col-lg-4">
                            <div class="items">
                                <div class="img">
                                    <img src="{{ @asset($image->image) }}" alt="">
                                </div>
                                <a href="{{ @asset($image->image) }}" data-fancybox="gallery" class="show"><i
                                        class="far fa-eye"></i></a>
                            </div>
                        </div>
                        @endforeach

               
                        <!-- end projects -->
                    </div>
                </div>
            </div>
        </section>
          <!-- --------------------- start subscribe ---------------------- -->
        @include('front.layouts.subscription_mail')
    </main>

@stop