@extends('front.layouts.main')
@section('meta_tags')
       <title>{{ @$article->translations->where('lang_id',$active_lang->id)->first()->title }} | {{@$setting->translation->title}}</title>
    <meta name='description' itemprop='description' content='{!! @$info->translation->content!!}' />
    <meta name='keywords' content='{!!@$setting->meta_tags!!},{!!@$info->translation->title !!},{!!@$info->mission !!},{!!@$info->goals!!}' />
    <meta property="og:description"content="{{ @$info->translation->content }}" />
    <meta property="og:title"content="{{ @$article->translations->where('lang_id',$active_lang->id)->first()->title }} | {{@$setting->translation->title}} " />
    <meta property="og:url"content="{{URL::to('/news')}}" />
    <meta property="og:site_name"content="{{@$setting->translation->title}}" />
    <meta property="og:image" content="{{URL::to('/').@$setting->logo}}">

    <meta name="twitter:card"content="summary" />
    <meta name="twitter:title"content="{{ @$article->translations->where('lang_id',$active_lang->id)->first()->title }}| {{@$setting->translation->title}}" />
    <meta name="twitter:site"content="@wait" />
@stop
@section('content')
   <!--inner-header-->
    <section class="inner-header section-padding">
        <div class="container">
            <div class="section-head text-center">
                <h2>@lang('home.details')</h2>
            </div>
        </div>
    </section>
    <!--inner-header-->
    <!--Contents-->
    <main>
        <!-- ======================== start news details =========================== -->
        <section class="news-det section-padding">
            <div class="container">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="info">
                            <div class="img">
                                <img src="{{ @asset($article->image) }}" alt="">
                            </div>
                            <h4>{{ @$article->translations->where('lang_id',$active_lang->id)->first()->title }}</h4>
                            <p>{!! $article->translations->where('lang_id',$active_lang->id)->first()->content !!}</p>
                     
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="aside">
                            <h5>@lang('home.latest_news')</h5>
                            <ul>
                                @foreach($lates_news as $lnew)
                                <li>
                                    <a href="#">
                                        <img src="{{ asset($lnew->image) }}" alt="">
                                        <h6>{{ @$lnew->translations->where('lang_id',$active_lang->id)->first()->title }}</h6>
                                        <p>{!!  @$article->translations->where('lang_id',$active_lang->id)->first()->content  !!} <a href="{{ url(LaravelLocalization::getCurrentLocale().'/article/'.$lnew->id) }}">@lang('home.more')</a></p>
                                    </a>
                                </li>
                                @endforeach
                          
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>
      
      
        <!-- --------------------- start subscribe ---------------------- -->
        @include('front.layouts.subscription_mail')
    </main>
    <!--End-Contents-->
@stop