@extends('front.layouts.main')
@section('meta_tags')
       <title>@lang('home.news') | {{@$setting->translation->title}}</title>
    <meta name='description' itemprop='description' content='{!! @$info->translation->content!!}' />
    <meta name='keywords' content='{!!@$setting->meta_tags!!},{!!@$info->translation->title !!},{!!@$info->mission !!},{!!@$info->goals!!}' />
    <meta property="og:description"content="{{ @$info->translation->content }}" />
    <meta property="og:title"content="@lang('home.news') | {{@$setting->translation->title}} " />
    <meta property="og:url"content="{{URL::to('/news')}}" />
    <meta property="og:site_name"content="{{@$setting->translation->title}}" />
    <meta property="og:image" content="{{URL::to('/').@$setting->logo}}">

    <meta name="twitter:card"content="summary" />
    <meta name="twitter:title"content="@lang('home.news')| {{@$setting->translation->title}}" />
    <meta name="twitter:site"content="@wait" />
@stop
@section('content')

       <!--Contents-->
    <main>
        <!-- --------------------- start news ---------------------- -->
        <section class="news section-padding">
            <div class="container">
                <div class="content">
                    <!-- our projects -->
                    <div class="row">
                        @foreach($news as $new)
                        <div class="col-lg-4">
                            <div class="items wow zoomIn">
                                <div class="img">
                                    <img src="{{ @asset($new->image) }}" alt="">
                                </div>
                                <div class="info">
                                    <div class="date">
                                      {{@Carbon\Carbon::parse($new->created_at)->diffForHumans()}}
                                        {{-- <span><i class="far fa-user"></i> محمد احمد</span> --}}
                                    </div>
                                   <h5>{{ @$new->translations->where('lang_id',$active_lang->id)->first()->title }}</h5>
                                    <small>{!! @$new->translations->where('lang_id',$active_lang->id)->first()->content !!}<a href="{{ url(LaravelLocalization::getCurrentLocale().'/article/'.$new->id) }}">@lang('home.more')</a></small>
                                </div>
                            </div>
                        </div>
                        @endforeach
    
                
                    </div>
                    <div class="pagination text-center">
                        {{ $news->links() }}
                    </div>
                </div>
            </div>
        </section>
        <!-- --------------------- start subscribe ---------------------- -->
        @include('front.layouts.subscription_mail')
       
    </main>
    <!--End-Contents-->

@stop