<?php



use Illuminate\Support\Facades\Schema;

use Illuminate\Database\Schema\Blueprint;

use Illuminate\Database\Migrations\Migration;



class CreateCityTranslationsTable extends Migration

{

    /**

     * Run the migrations.

     *

     * @return void

     */

    public function up()

    {

        Schema::create('city_translations', function (Blueprint $table) {

            $table->increments('id');

            $table->string('name');

            $table->unsignedInteger('city_id');

            $table->foreign('city_id')->references('id')->on('cities')->onDelete('cascade');

            $table->unsignedInteger('lang_id');

            $table->foreign('lang_id')->references('id')->on('setting_langs')->onDelete('cascade');

            $table->timestamps();

        });

    }



    /**

     * Reverse the migrations.

     *

     * @return void

     */

    public function down()

    {

        Schema::dropIfExists('city_translations');

    }

}

