<?php



use Illuminate\Support\Facades\Schema;

use Illuminate\Database\Schema\Blueprint;

use Illuminate\Database\Migrations\Migration;



class CreateExternalResourcesTable extends Migration

{

    /**

     * Run the migrations.

     *

     * @return void

     */

    public function up()

    {

        Schema::create('external_resources', function (Blueprint $table) {

            $table->increments('id');

            $table->unsignedInteger('setting_id');

            $table->foreign('setting_id')->references('id')->on('settings')->onDelete('cascade');



            $table->string('file')->nullable();

            $table->timestamps();

        });

    }



    /**

     * Reverse the migrations.

     *

     * @return void

     */

    public function down()

    {

        Schema::dropIfExists('external_resources');

    }

}

