<?php



use Illuminate\Support\Facades\Schema;

use Illuminate\Database\Schema\Blueprint;

use Illuminate\Database\Migrations\Migration;



class CreateUsersTable extends Migration

{

    /**

     * Run the migrations.

     *

     * @return void

     */

    public function up()

    {

        Schema::create('users', function (Blueprint $table) {

            $table->bigIncrements('id');

            $table->string('fname')->nullable();

            $table->string('lname')->nullable();

            $table->string('email')->unique();

            $table->timestamp('email_verified_at')->nullable();

            $table->string('phone')->nullable();

            $table->string('address')->nullable();

            $table->string('lat')->nullable();

            $table->string('long')->nullable();

            $table->integer('country_id')->nullable()->unsigned();

            $table->foreign('country_id')->references('id')->on('countries')->onDelete('cascade');

            $table->integer('city_id')->nullable()->unsigned();

            $table->foreign('city_id')->references('id')->on('cities')->onDelete('cascade');

            $table->enum('gander',['male','female']);

            $table->enum('type_user',['user','companies','admin']);

            $table->enum('status',['not_verify','active','suspended','deactive']);

            $table->string('suspended_reason')->nullable();

            $table->string('deactive_reason')->nullable();

            $table->string('image')->default('img/avatar.png');

            $table->string('password');

            $table->rememberToken();

            $table->softDeletes();

            $table->timestamps();

        });

    }



    /**

     * Reverse the migrations.

     *

     * @return void

     */

    public function down()

    {

        Schema::dropIfExists('users');

    }

}

