<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use App\Setting,App\City,App\Aboutus,App\TestMonials;
use App\Category,App\Languages,App\SettingLangs;
use App\Pages,App\ContctUs,App\ReasonsReport,App\Jobs;
use LaravelLocalization;
use App;
use Config;
class AppServiceProvider extends ServiceProvider
{
  
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        App::booted(function()
        {
            if (\Schema::hasTable('settings')) {
                $setting = Setting::with('social_media_link')
                // ->groupby('')->distinct()
                ->first();
                // dd($setting);
                Config::set('app.name',@$setting->translation->title);
                Config::set('mail.driver',@$setting->mail_provider_info->MAIL_DRIVER);
                Config::set('mail.host',@$setting->mail_provider_info->MAIL_HOST);
                Config::set('mail.port',@$setting->mail_provider_info->MAIL_port);
                Config::set('mail.username',@$setting->mail_provider_info->MAIL_USERNAME);
                Config::set('mail.password',@$setting->mail_provider_info->MAIL_PASSWORD);
                view()->share('setting', $setting);
            }
            if(\Schema::hasTable('cities')){
                $cities = City::all();
                view()->share('cities', $cities);
            }

            if(\Schema::hasTable('pages')){
                $pages = Pages::where('status','show')->get();
                $policy = Pages::where('status','show')->where('url','policy')->first();
                view()->share('pages', $pages);
                view()->share('policy', $policy);
            }

            if(\Schema::hasTable('test_monials')){
                $galleries = TestMonials::all();
                view()->share('galleries', $galleries);
            }
            
            if (\Schema::hasTable('aboutus')) {
                $info = Aboutus::first();
                view()->share('info', $info);
            }

            if (\Schema::hasTable('contctus')) {
                $contact = ContctUs::where('read','0')->get();
                view()->share('contact', $contact);
            }


            if (\Schema::hasTable('pages')) {
                $pages = Pages::where('status','show')->get();
                view()->share('pages', $pages);
            }

            if (\Schema::hasTable('categories')) {
                $categories = Category::where('parent_id',NULL)->with('translations','services')->take(4)->get();
                view()->share('categories', $categories);
            }

            if (\Schema::hasTable('languages')) {
                $languages = Languages::all();
                view()->share('languages', $languages);
            }

            if (\Schema::hasTable('setting_langs')) {
                $site_langs = SettingLangs::all();
                view()->share('site_langs', $site_langs);
            }

            if (\Schema::hasTable('reasons_reports')) {
                $gallerries_categories =ReasonsReport::all();
                view()->share('gallerries_categories', $gallerries_categories);
            }   

              if (\Schema::hasTable('jobs')) {
                $jobs =Jobs::all();
                view()->share('jobs', $jobs);
            }   

            $active_lang = Languages::where('local',LaravelLocalization::getCurrentLocale())->first();
                view()->share('active_lang', $active_lang);
           
            
        });
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {

        Schema::defaultStringLength(191);

    }
}
