<?php

namespace App\Http\Controllers\Front;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Slider,App\Pages,App\Blog;
use App\Category;
use App\Jobs;
use App\TestMonials;

class HomeController extends Controller
{
    public function index()
    {
    	$sliders = Slider::orderBy('created_at','DESC')->get();
        $blogs = Blog::take(3)->get();
    	return view('front.index',compact('sliders','blogs'));
    }

    public function contact()
    {
    	return view('front.contact_us');
    }

    public function about_us()
    {
        return view('front.about_us');
    }

    public function page($id,$url= null)
    {
        $page = Pages::find($id);
    	return view('front.pages.show',compact('page'));
    }

    public function service($id,$url= null)
    {
        $category = Category::find($id);

        return view('front.categories.show',compact('category'));
    }

    public function news()
    {
        $news = Blog::paginate(15);

        return view('front.blogs.index',compact('news'));
        
    }

     public function BlogShow($id)
    {
         if (Blog::find($id) == null) {
            return abort(404);
        }
        $article = Blog::find($id);
        $lates_news = Blog::where('id','!=',$id)->get();
        
        return view('front.blogs.show',compact('article','lates_news'));
        
    }

    public function projects()
    {
        $projects= TestMonials::with('translations','galleries')->paginate(15);
        return view('front.projects.index',compact('projects'));
    }

    public function projectShow($project_id,$name=null)
    {
        if (TestMonials::find($project_id) == null) {
            return abort(404);
        }
        $project= TestMonials::find($project_id);
        return view('front.projects.show',compact('project'));
    }

    public function jobDetails($job_id,$name=null)
    {
        if (Jobs::find($job_id) == null) {
            return abort(404);
        }
        $job= Jobs::find($job_id);
        return view('front.jobs.show',compact('job'));
    }
}
