<?php

namespace App\Http\Controllers\Auth;

use App\User;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Validation\Rule;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = '/admin/home';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'phone' => ['required'],
            'address' => ['required'],
            // 'commercial_register' => ['required'],
            // 'governmental_id' => ['required'],
            'job_title' => ['required'],
            // 'country_id' => ['required'],
            // 'city_id' => ['required'],
            'gander' => ['required'],
            'password' => ['required'],
            'terms' => ['required'],
            'gander'=> [
                        'required',
                        Rule::in(['male', 'female']),
                    ],
            'user_type'=> [
                        'required',
                        Rule::in(['user', 'companies']),
                    ],
            'password'=>'required',// English uppercase characters (A – Z) - English lowercase characters (a – z) - Base 10 digits (0 – 9) - Non-alphanumeric (For example: !, $, #, or %) - Unicode characters
            // ['required', 'string', 'min:8', 'confirmed'],
        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\User
     */
    protected function create(array $data)
    {

        return User::create([
            'fname'=>$data['name'],
            'email'=>$data['email'],
            'phone'=>$data['phone'],
            'address'=>$data['address'],
            'commercial_register'=>@$data['commercial_register'],
            'governmental_id'=>@$data['governmental_id'],
            'job_title'=>$data['job_title'],
            'country_id'=>@$data['country_id'],
            'city_id'=>@$data['city_id'],
            'gander'=>$data['gander'],
            'password'=>bcrypt($data['password']),
            'image'=>'img/avatar.png',
            'type_user'=>$data['user_type']

        ]);
    }
}
