<?php

namespace App\Http\Controllers\Api\Auth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\LoginRequest;
use Carbon\Carbon;
use App\Http\Resources\Api\UserInfoResource;
use Validator;
use Response;
use App\User;
use Auth;

class LoginController extends Controller
{
    
    public function validation($request)
    {
         $validator = Validator::make($request, [
            'user_key'=>'required',
            'password'=>'required', 
        ]);

        if ($validator->fails()) {
            $msg = $validator->errors()->first();
            $response = [
                    'success'=>FALSE,
                    'message'=>$msg,
                    'data'=>[]
                ];   
               return $response;  
        }
    }

    public function login(Request $request)
    {
        $validation = $this->validation($request->all());      
        if($validation != null){
            return Response::json($validation,400) ; 
        } 

        $user = $request->user_key;
        $password = $request->password;

        if (!Auth::attempt(['email' => $user, 'password' => $password]) || Auth::attempt(['phone' => $user, 'password' => $password])) {
               $msg = 'unauthorized';
               $response = [
	                'success'=>FALSE,
               		'message'=>$msg,
               		'data'=>[]
           		];   
               return Response::json($response,400);
            }

            $user = $request->user();
            $user = new  UserInfoResource(User::find($user->id));
            $tokenResult = $user->createToken('Personal Access Token');
            $token = $tokenResult->token;
            
            if ($request->remember_me == 'on') {
                $token->expires_at = Carbon::now()->addWeeks(3);
                $token->save();
            }

            $msg = 'success';
            $response = [
                'message'=>$msg,
                'success'=>TRUE,
                'data'=>[
                'user'=>$user,
                'access_token' => $tokenResult->accessToken,
                'token_type' => 'Bearer',
                'expires_at' => Carbon::parse(
                    $tokenResult->token->expires_at
                )->toDateTimeString()
                ]
                
            ];   
           return Response::json($response,200);        
    }



}
