<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\ReasonsReport,App\ReasonsReportTranslations;
use Jenssegers\Agent\Agent;
use App\Helpers\DoFire;
use Session;
use Auth;

class ReasonsReportController extends Controller
{
	public $view = 'panel.report_reasons.';

    public function __construct(
			ReasonsReport $model,
			ReasonsReportTranslations $translation
		)
	{
        $this->model = $model;
        $this->translation = $translation;
	}

	public function index()
	{
		$reasons = $this->model->orderBy('created_at','DESC')->get();
		return view($this->view.'index',compact('reasons'));
	}

	public function create()
	{
		$reason = [];
		return view($this->view.'create',compact('reason'));
	}

	public function store(Request $request)
	{
		
		$insert =  $this->model->create($request->except('name','ipinfo','_token','lang'));

    	foreach ($request->lang as $key => $lang) {
			$translations = $this->translation->create([
									'lang_id'=>$lang,
									'reasons_id'=>$insert->id,
									'name'=>$request->name[$key],
							]);
		}

		

		Session::flash('success',trans('home.message_success'));
		return redirect()->back();
	}

	
	public function edit($id)
	{
		$reason = $this->model->find($id);
		
		return view($this->view.'edit',compact('reason'));
	}


	public function update(Request $request,$id)
	{
	
		 $this->model->find($id)->update($request->except('name','_method','use','ipinfo','_token','lang'));

		$this->translation->where('reasons_id',$id)->delete();
		foreach ($request->lang as $key => $lang) {
			$translations = $this->translation->create([
									'lang_id'=>$lang,
									'reasons_id'=>$id,
									'name'=>$request->name[$key],
							]);
		}
    	
		Session::flash('success',trans('home.message_success'));
		return redirect()->back();
	}

	


	public function destroy($id,Request $request)
    {

       $agent = new Agent();
       $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
       $data = ['key'=>'dashboard_destroy_group_id'.$id,'text'=>'Destroy group Info','browser'=>$agent];
       $info  = $this->model->find($id);

           DoFire::MK_REPORT($data,Auth::id(),$info,$request->ipinfo);
           $this->model->destroy($id);
        Session::flash('success',trans('home.message_success'));
        return redirect()->back();  
    }


    public function destroySelected(Request $request)
    {

       $agent = new Agent();
       $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
       $data = ['key'=>'dashboard_destroy_group_ids_['.json_encode($request->ids).']','text'=>'Destroy selected Group Info','browser'=>$agent];

        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);

        if ($request->has('ids')) {
            $this->model->wherein('id',$request->ids)->delete();
        }else{
        $this->model->truncate();
        }
        Session::flash('success',trans('home.message_success'));
        return redirect()->back();  
    }

}
