<?php
/*
*********************************
* Name: Amr Muhamed             *
* Email: amrmuhamed9@gmail.com  *
* Phone: +201061637022          *
* Copywrits @amrMU Githup       *
* *******************************
*/
namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Jenssegers\Agent\Agent;
use App\Helpers\DoFire;
use App\Http\Requests\Admin\BlogRequest;
use App\Blog;
use App\BlogTranslation;
use Session;
use Auth;

class BlogsController extends Controller
{
	public $view = 'panel.notifications.';

    public function __construct(
			Blog $blog,
			BlogTranslation $translation
		)
	{
        $this->blog = $blog;
        $this->translation = $translation;
	}

	public function index(Request $request)
	{
		$blogs = $this->blog->paginate(30);
		$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_List_Blogs_Article','text'=>'List Blogs Article  ','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);

        return view($this->view.'index',compact('blogs'));

	}

    public function create(Request $request)
    {
    		$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_create_blog','text'=>'Create Article  ','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);
        return view($this->view.'create');
    }

    public function store(BlogRequest $request)
    {
		if($request->hasFile('image')){
            $file =$request->file('image'); 
			$time = time();
			$ext = $file->getClientOriginalExtension();
			$fullname = $time . '.' . $ext;
            $move = $file->move(public_path() .'/uploads/images/news', $fullname);
            $path ='/uploads/images/news';
            $image = $path.'/'.$fullname;
        }else{
            $image = '/img/no_image.png';
		}
		// dd($image);
		$create = $this->blog->create([
			'meta_tags'=>$request->meta_tags,
			'image'=>$image,
			'status'=>'show',
		]);
		if ($request->has('lang')) {
			$translation = [];
			foreach ($request->lang as $key => $lang) {
			$translation =	$this->translation->create([
									'blog_id'=>$create->id,
									'lang_id'=>$lang,
									'title'=>$request->title[$key],
									'content'=>$request->content[$key],
								]);
			}//end loop save translation
		}//end languages when we lave lang

    	$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_List_Blogs_Article','text'=>'List Blogs Article  ','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),$create,$request->ipinfo);

    	Session::flash('success',trans('home.message_success'));
    	return redirect()->back();

    }

    public function edit($id,Request $request)
    {
    	$blog = $this->blog->find($id);
    	$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_update_article_id_'.$id,'text'=>'update Article Info ','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);
        return view($this->view.'edit',compact('blog'));
    }

    public function update($id,BlogRequest $request)
    {
		
		if($request->hasFile('image')){
            $file =$request->file('image'); 
			$time = time();
			$ext = $file->getClientOriginalExtension();
			$fullname = $time . '.' . $ext;
            $move = $file->move(public_path() .'/uploads/images/news', $fullname);
            $path ='/uploads/images/news';
            $image = $path.'/'.$fullname;
        }else{
            $image = $this->blog->find($id)->image;
		}

			$update = $this->blog->find($id)->update([
				'meta_tags'=>$request->meta_tags,
				'image'=>$image,
				'status'=>'show',
			]);
			// dd($image,$request->hasFile('image'), $this->blog->find($id));

		if ($request->has('lang')) {
			$this->translation->where('blog_id',$id)->delete();
			$translation = [];
			foreach ($request->lang as $key => $lang) {
				$translation =	$this->translation->create([
					'blog_id'=>$id,
					'lang_id'=>$lang,
					'title'=>$request->title[$key],
					'content'=>$request->content[$key],
				]);
			}	//end loop save translation
		}//end languages when we lave lang

    	$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_update_article','text'=>'Update Blogs Article  ','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),$this->blog->find($id),$request->ipinfo);

    	Session::flash('success',trans('home.message_success'));
    	return redirect()->back();

    }

		public function show($value='')
		{
			// code...
		}

		public function search(Request $request)
		{
			$key = $request->key;
			$blogs = $this->blog->where('title_ar',$request->key)
															->orWhere('title_en',$request->key)
															->orWhere('content_ar',$request->key)
															->orWhere('content_en',$request->key)
															->paginate(30);

			return view($this->view.'index',compact('blogs','key'));
		}

		public function destroy($id,Request $request)
		{
			$agent = new Agent();
			$agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
			$data = ['key'=>'dashboard_Delete_Article_has_ID:'.$id,'text'=>'Delete Article Blogs','browser'=>$agent];
			DoFire::MK_REPORT($data,Auth::id(),$this->blog->find($id),$request->ipinfo);
			$this->blog->destroy($id);
			Session::flash('success',trans('home.message_success'));
			return redirect()->back();
		}

		public function destroySelected (Request $request)
		{
	
		   $agent = new Agent();
		   $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
		   $data = ['key'=>'dashboard_destroy_blog_ids_['.json_encode($request->ids).']','text'=>'Destroy selected ad Info','browser'=>$agent];
	
			DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);
	
			if ($request->has('ids')) {
				$this->blog->wherein('id',$request->ids)->delete();
			}else{
				$this->blog->truncate();
			}
			Session::flash('success',trans('home.message_success'));
			return redirect()->back();  
		}
	
	
}
