<!DOCTYPE html>
<html>

<head>


    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <link rel="shortcut icon" href="<?php echo e(asset('/site')); ?>/images/favicon.ico" title="Favicon" sizes="16x16" />
    <?php echo $__env->yieldContent('meta_tags'); ?>
    <?php if(LaravelLocalization::getCurrentLocale() == 'en'): ?>
    <!--With LTR -->
    <link rel="stylesheet" href="<?php echo e(asset('site')); ?>/css/lib/bootstrap-ltr.min.css">
    <!--/With LTR -->
    <?php else: ?>
    <!--With RTL -->
    <link rel="stylesheet" href="<?php echo e(asset('site')); ?>/css/lib/bootstrap-rtl.min.css" />
    <!--/With RTL -->
    <?php endif; ?>
    <link href="https://fonts.googleapis.com/css?family=Nunito+Sans:300,400,600,700,800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('site')); ?>/css/lib/animate.css" />
    <link rel="stylesheet" href="<?php echo e(asset('site')); ?>/css/lib/all.min.css" />
    <link rel="stylesheet" href="<?php echo e(asset('site')); ?>/css/lib/owl.carousel.min.css" />
    <link rel="stylesheet" href="<?php echo e(asset('site')); ?>/css/lib/owl.theme.default.min.css" />
    <link rel="stylesheet" href="<?php echo e(asset('site')); ?>/css/lib/jquery.fancybox.css" />
    <link rel="stylesheet" href="<?php echo e(asset('site')); ?>/css/lib/magnific-popup.css" />
    <link rel="stylesheet" href="<?php echo e(asset('site')); ?>/css/lib/swiper.css" />
    <link rel="stylesheet" href="<?php echo e(asset('site')); ?>/css/styles.css" />
    <?php if(LaravelLocalization::getCurrentLocale() == 'en'): ?>
    <link rel="stylesheet" href="<?php echo e(asset('site')); ?>/css/style_en.css"> 
    <?php endif; ?>
    
</head>

<body>
  
<!--Menu-->
    <div class="top-nav">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="time">
                        <i class="far fa-clock"></i>
                        <span><?php echo app('translator')->getFromJson('home.Blood_24_hours_week'); ?> </span>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="mail text-right">
                        <ul>
                            <li><a href="#"><?php echo e(@$setting->emails->first()->email); ?></a> <i class="far fa-envelope"></i> </li>
                            <li><a href="#"><?php echo e(@$setting->phones->first()->phone); ?></a> <i class="fas fa-phone-volume"></i> </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <section class="navbar">
        <nav class="custom-navbar">
            <div class="container">
                <div class="row">
                    <div class="col-lg-4">
                        <div class="logo">
                            <a class="navbar-brand" href="<?php echo e(url(LaravelLocalization::getCurrentLocale())); ?>"><img src="<?php echo e(asset($setting->logo)); ?>" alt=""></a>
                            <div class="nav-toggle">
                                <span></span>
                                <span></span>
                                <span></span>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-8">

                        <ul class="nav-list">
                            <li>
                                <div class="mob-logo">
                                    <span><img src="<?php echo e(asset($setting->logo)); ?>" alt=""></span>
                                </div>
                            </li>
                            <li class="nav-items"><a class="nav-links" href="<?php echo e(url(LaravelLocalization::getCurrentLocale())); ?>"><?php echo app('translator')->getFromJson('home.home'); ?></a></li>
                            <li class="nav-items"><a class="nav-links" href="<?php echo e(url(LaravelLocalization::getCurrentLocale().'/about_us')); ?>"><?php echo app('translator')->getFromJson('home.about_us'); ?></a></li>
                            <li class="nav-items drop-nav">
                                <a class="nav-links" href="#0"><?php echo app('translator')->getFromJson('home.services'); ?> </a>
                                <ul class="drop-down">
                                    <?php $__currentLoopData = @$categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ser_key => $cat_service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <li><a href="<?php echo e(url(LaravelLocalization::getCurrentLocale().'/serivce/'.$cat_service->id.'/'.@str_replace(' ','_',$cat_service->translations->where('lang_id',$active_lang->id)->first()->name))); ?>"><?php echo e(@$cat_service->translations->where('lang_id',$active_lang->id)->first()->name); ?></a></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    
                                    
                                    
                                </ul>
                            </li>
                            <li class="nav-items"><a class="nav-links" href="<?php echo e(url(LaravelLocalization::getCurrentLocale().'/projects/')); ?>"><?php echo app('translator')->getFromJson('home.gallery'); ?> </a></li>
                            <li class="nav-items"><a class="nav-links" href="<?php echo e(url(LaravelLocalization::getCurrentLocale().'/news/')); ?>"><?php echo app('translator')->getFromJson('home.news'); ?> </a></li>
                         
                            <li class="nav-items"><a class="nav-links" href="<?php echo e(url(LaravelLocalization::getCurrentLocale().'/contact')); ?>"><?php echo app('translator')->getFromJson('home.contactus'); ?></a></li>
                             <li class="nav-items drop-nav">
                                <a class="nav-links" href="#0"><?php echo app('translator')->getFromJson('home.lang'); ?> </a>
                                <ul class="drop-down">
                                   <?php $__currentLoopData = LaravelLocalization::getSupportedLocales(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $localeCode => $properties): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <a rel="alternate" hreflang="<?php echo e($localeCode); ?>" href="<?php echo e(LaravelLocalization::getLocalizedURL($localeCode, null, [], true)); ?>">
                                                <?php echo e($properties['native']); ?>

                                            </a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    
                                    
                                    
                                </ul>
                            </li>
                            <!-- Button trigger modal -->
                           
                        </ul>
                    </div>
                </div>
            </div>
            <div class="overlay"></div>
        </nav>
        <!-- Modal -->
        <div class="modal fade" id="serviceOrder" tabindex="-1" role="dialog" aria-labelledby="serviceOrderTitle"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLongTitle">طلب خدمه</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="contact-form">
                            <form>
                                <div class="form-group">
                                    <input type="text" class="form-control" placeholder="الأسم">
                                </div>
                                <div class="form-group">
                                    <input type="text" class="form-control" placeholder="رقم الجوال">
                                </div>
                                <div class="form-group">
                                    <input type="text" class="form-control" placeholder="البريد الاليكترونى">
                                </div>
                                <div class="form-group">
                                    <select class="custom-select form-control">
                                        <option selected>نوع الخدمه</option>
                                        <option value="1">التشييد والبناء</option>
                                        <option value="2">اعمال نظافة </option>
                                        <option value="3">اعمال صيانة</option>
                                        <option value="4">خدمات التشغييل ( تاجير عمال - عقود عمالة )</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <input type="text" class="form-control" placeholder="اللوكيشن">
                                </div>
                                <div class="form-group text-center">
                                    <button class="butn mt-3"><span>ارسال</span></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!--End-Menu-->
 
    <?php echo $__env->yieldContent('content'); ?>
    <!--Footer-->
    <footer class="pt-5">
        <div class="container">
            <div class="row">
                <div class="col-md-4">
                    <div class="items about">
                        <h4><?php echo app('translator')->getFromJson('home.about_us'); ?></h4>
                        <p><?php echo e(@substr($info->translations->where('lang_id',$active_lang->id)->first()->content,0, 550).'...'); ?></p>
                        <div class="socail">
                            <?php $__currentLoopData = $setting->social_media_link; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chanel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e($chanel->url); ?>" target="_blank"><img src="<?php echo e(@asset($chanel->icon)); ?>"></a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                    <div class="items links">
                        <h4><?php echo app('translator')->getFromJson('home.jobs'); ?></h4>
                        <ul>
                            <?php $__currentLoopData = $jobs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><i class="fas fa-angle-double-left"></i><a href="<?php echo e(url(LaravelLocalization::getCurrentLocale()).'/job/'.@$job->id.'/'.str_replace(' ', '_', $job->translations->where('lang_id',$active_lang->id)->first()->title )); ?>"><?php echo e($job->translations->where('lang_id',$active_lang->id)->first()->title); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                 
                        </ul>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="items">
                        <h4><?php echo app('translator')->getFromJson('home.contact_info'); ?></h4>
                        <ul>
                            <?php $__currentLoopData = $setting->phones->take(1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><i class="fas fa-mobile-alt"></i> <?php echo e(@$phone->phone); ?> </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                            <?php $__currentLoopData = $setting->whatsapp->take(1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $whatsapp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><i class="fab fa-whatsapp"></i> <?php echo e(@$whatsapp->whatsapp); ?> </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php $__currentLoopData = $setting->emails->take(1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $email): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><i class="far fa-envelope-open"></i> <?php echo e(@$email->email); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        
                            <?php $__currentLoopData = $setting->address->take(1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><i class="fas fa-location-arrow"></i><?php echo e(@$address->address_ar); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <div class="foot">
        </div>
    </footer>
    <!--End-Footer-->
    <!-- -------------- request ----------------- -->
    <!-- <a class="to-top" data-scroll href="#bazinga" id="scroll-btn">
        <i class="fa fa-arrow-up"></i>
    </a> -->
    <script src="<?php echo e(asset('/site')); ?>/js/lib/jquery-3.0.0.min.js"></script>
    <script src="<?php echo e(asset('/site')); ?>/js/lib/jquery-migrate-3.0.0.min.js"></script>
    <script src="<?php echo e(asset('/site')); ?>/js/lib/popper.min.js"></script>
    <script src="<?php echo e(asset('/site')); ?>/js/lib/bootstrap.min.js"></script>
    <script src="<?php echo e(asset('/site')); ?>/js/lib/wow.min.js"></script>
    <script src="<?php echo e(asset('/site')); ?>/js/lib/jquery.fancybox.js"></script>
    <script src="<?php echo e(asset('/site')); ?>/js/lib/jquery.easing-1.3.pack.js"></script>
    <script src="<?php echo e(asset('/site')); ?>/js/lib/jquery.mousewheel-3.0.4.pack.js"></script>
    <script src="<?php echo e(asset('/site')); ?>/js/lib/owl.carousel.min.js"></script>
    <script src="<?php echo e(asset('/site')); ?>/js/lib/smooth-scroll.min.js"></script>
    <script src="<?php echo e(asset('/site')); ?>/js/lib/jquery.nicescroll.min.js"></script>
    <script src="<?php echo e(asset('/site')); ?>/js/lib/mixitup.min.js"></script>
    <script src="<?php echo e(asset('/site')); ?>/js/lib/typed.min.js"></script>
    <script src="<?php echo e(asset('/site')); ?>/js/lib/scrollIt.min.js"></script>
    <script src="<?php echo e(asset('/site')); ?>/js/lib/jquery.waypoints.min.js"></script>
    <script src="<?php echo e(asset('/site')); ?>/js/lib/jquery.counterup.js"></script>
    <script src="<?php echo e(asset('/site')); ?>/js/lib/typed.js"></script>
    <script src="<?php echo e(asset('/site')); ?>/js/lib/jquery.magnific-popup.min.js"></script>
    <script src="<?php echo e(asset('/site')); ?>/js/lib/tilt.jquery.js"></script>
    <script src="<?php echo e(asset('/site')); ?>/js/lib/swiper.js"></script>
    <script src="<?php echo e(asset('/site')); ?>/js/lib/particles.min.js"></script>
    <script src="<?php echo e(asset('/site')); ?>/js/lib/app.js"></script>
    <script src="<?php echo e(asset('/site')); ?>/js/main.js"></script>
    <?php echo $__env->yieldContent('jsCode'); ?>
    
</body>

</html><?php /**PATH /home/balyomhost/public_html/amr/remoz/resources/views/front/layouts/main.blade.php ENDPATH**/ ?>