@extends('front.layouts.main')
@section('meta_tags')
    <title>@lang('home.gallery') | {{@$setting->translation->title}}</title>
    <meta name='description' itemprop='description' content='{!! @$info->translation->content!!}' />
    <meta name='keywords' content='{!!@$setting->meta_tags!!},{!!@$info->translation->title !!},{!!@$info->mission !!},{!!@$info->goals!!}' />
    <meta property="og:description"content="{{ @$info->translation->content }}" />
    <meta property="og:title"content="@lang('home.gallery') | {{@$setting->translation->title}} " />
    <meta property="og:url"content="{{URL::to('/news')}}" />
    <meta property="og:site_name"content="{{@$setting->translation->title}}" />
    <meta property="og:image" content="{{URL::to('/').@$setting->logo}}">

    <meta name="twitter:card"content="summary" />
    <meta name="twitter:title"content="@lang('home.gallery')| {{@$setting->translation->title}}" />
    <meta name="twitter:site"content="@wait" />
@stop
@section('content')

 <!--inner-header-->
    <section class="inner-header section-padding">
        <div class="container">
            <div class="section-head text-center">
                <h2>معرض الصور</h2>
            </div>
        </div>
    </section>
    <!--inner-header-->
    <!--Contents-->
    <main>
        <!-- --------------------- start gallery pg ---------------------- -->
        <section class="portfolio gallery-pg section-padding">
            <div class="container">
                <div class="content">
                    <!-- our projects -->
                    <div class="row content wow fadeInUp">
        
                         @foreach($projects as $ga_key =>$gallery)
                        <div class="col-lg-4 ">
                            <div class="items">
                                <div class="img">
                                    <img src="{{@asset($gallery->galleries->first()->image)}}" alt="">
                                </div>
                                <div class="info">
                                    <small>{{ @$gallery->category->translations->where('lang_id',$active_lang->id)->first()->name }}</small>
                                    <h6><a href="{{url(LaravelLocalization::getCurrentLocale()).'/projects/'.$gallery->id.'/'.str_replace(' ','_', $gallery->translations->where('lang_id',$active_lang->id)->first()->title)}}">{{ @$gallery->translations->where('lang_id',$active_lang->id)->first()->title }}</a></h6>
                                </div>
                            </div>
                        </div>
                        @endforeach
                        <!-- end projects -->
                    </div>
                    <div class="pagination text-center">
                        <ul>
                            {!! $projects->render() !!}
                          
                        </ul>
                    </div>
                </div>
            </div>
        </section>
        <!-- --------------------- start mail ---------------------- -->
        @include('front.layouts.subscription_mail')
        
    </main>
    <!--End-Contents-->

@stop