<!DOCTYPE html>
<html>

<head>


    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <link rel="shortcut icon" href="{{asset('/site')}}/images/favicon.ico" title="Favicon" sizes="16x16" />
    @yield('meta_tags')
    @if(LaravelLocalization::getCurrentLocale() == 'en')
    <!--With LTR -->
    <link rel="stylesheet" href="{{asset('site')}}/css/lib/bootstrap-ltr.min.css">
    <!--/With LTR -->
    @else
    <!--With RTL -->
    <link rel="stylesheet" href="{{asset('site')}}/css/lib/bootstrap-rtl.min.css" />
    <!--/With RTL -->
    @endif
    <link href="https://fonts.googleapis.com/css?family=Nunito+Sans:300,400,600,700,800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="{{asset('site')}}/css/lib/animate.css" />
    <link rel="stylesheet" href="{{asset('site')}}/css/lib/all.min.css" />
    <link rel="stylesheet" href="{{asset('site')}}/css/lib/owl.carousel.min.css" />
    <link rel="stylesheet" href="{{asset('site')}}/css/lib/owl.theme.default.min.css" />
    <link rel="stylesheet" href="{{asset('site')}}/css/lib/jquery.fancybox.css" />
    <link rel="stylesheet" href="{{asset('site')}}/css/lib/magnific-popup.css" />
    <link rel="stylesheet" href="{{asset('site')}}/css/lib/swiper.css" />
    <link rel="stylesheet" href="{{asset('site')}}/css/styles.css" />
    @if(LaravelLocalization::getCurrentLocale() == 'en')
    <link rel="stylesheet" href="{{asset('site')}}/css/style_en.css"> 
    @endif
    {{-- <title> رموز | الرئيسية</title> --}}
</head>

<body>
  
<!--Menu-->
    <div class="top-nav">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="time">
                        <i class="far fa-clock"></i>
                        <span>@lang('home.Blood_24_hours_week') </span>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="mail text-right">
                        <ul>
                            <li><a href="#">{{ @$setting->emails->first()->email }}</a> <i class="far fa-envelope"></i> </li>
                            <li><a href="#">{{ @$setting->phones->first()->phone }}</a> <i class="fas fa-phone-volume"></i> </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <section class="navbar">
        <nav class="custom-navbar">
            <div class="container">
                <div class="row">
                    <div class="col-lg-4">
                        <div class="logo">
                            <a class="navbar-brand" href="{{ url(LaravelLocalization::getCurrentLocale()) }}"><img src="{{asset($setting->logo)}}" alt=""></a>
                            <div class="nav-toggle">
                                <span></span>
                                <span></span>
                                <span></span>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-8">

                        <ul class="nav-list">
                            <li>
                                <div class="mob-logo">
                                    <span><img src="{{asset($setting->logo)}}" alt=""></span>
                                </div>
                            </li>
                            <li class="nav-items"><a class="nav-links" href="{{ url(LaravelLocalization::getCurrentLocale()) }}">@lang('home.home')</a></li>
                            <li class="nav-items"><a class="nav-links" href="{{ url(LaravelLocalization::getCurrentLocale().'/about_us') }}">@lang('home.about_us')</a></li>
                            <li class="nav-items drop-nav">
                                <a class="nav-links" href="#0">@lang('home.services') </a>
                                <ul class="drop-down">
                                    @foreach(@$categories as $ser_key => $cat_service)

                                    <li><a href="{{ url(LaravelLocalization::getCurrentLocale().'/serivce/'.$cat_service->id.'/'.@str_replace(' ','_',$cat_service->translations->where('lang_id',$active_lang->id)->first()->name)) }}">{{ @$cat_service->translations->where('lang_id',$active_lang->id)->first()->name }}</a></li>
                                    @endforeach
                                    {{-- <li><a href="#">خدمات الصيانة</a></li> --}}
                                    {{-- <li><a href="#">أعمال النظافة</a></li> --}}
                                    {{-- <li><a href="#">خدمات التشغيل</a></li> --}}
                                </ul>
                            </li>
                            <li class="nav-items"><a class="nav-links" href="{{ url(LaravelLocalization::getCurrentLocale().'/projects/') }}">@lang('home.gallery') </a></li>
                            <li class="nav-items"><a class="nav-links" href="{{ url(LaravelLocalization::getCurrentLocale().'/news/') }}">@lang('home.news') </a></li>
                         
                            <li class="nav-items"><a class="nav-links" href="{{ url(LaravelLocalization::getCurrentLocale().'/contact') }}">@lang('home.contactus')</a></li>
                             <li class="nav-items drop-nav">
                                <a class="nav-links" href="#0">@lang('home.lang') </a>
                                <ul class="drop-down">
                                   @foreach(LaravelLocalization::getSupportedLocales() as $localeCode => $properties)
                                        <li>
                                            <a rel="alternate" hreflang="{{ $localeCode }}" href="{{ LaravelLocalization::getLocalizedURL($localeCode, null, [], true) }}">
                                                {{ $properties['native'] }}
                                            </a>
                                        </li>
                                    @endforeach
                                    {{-- <li><a href="#">خدمات الصيانة</a></li> --}}
                                    {{-- <li><a href="#">أعمال النظافة</a></li> --}}
                                    {{-- <li><a href="#">خدمات التشغيل</a></li> --}}
                                </ul>
                            </li>
                            <!-- Button trigger modal -->
                           {{--  <li class="nav-items"><a class="nav-links active" href="#0" data-toggle="modal"
                                    data-target="#serviceOrder">طلب خدمه </a></li> --}}
                        </ul>
                    </div>
                </div>
            </div>
            <div class="overlay"></div>
        </nav>
        <!-- Modal -->
        <div class="modal fade" id="serviceOrder" tabindex="-1" role="dialog" aria-labelledby="serviceOrderTitle"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLongTitle">طلب خدمه</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="contact-form">
                            <form>
                                <div class="form-group">
                                    <input type="text" class="form-control" placeholder="الأسم">
                                </div>
                                <div class="form-group">
                                    <input type="text" class="form-control" placeholder="رقم الجوال">
                                </div>
                                <div class="form-group">
                                    <input type="text" class="form-control" placeholder="البريد الاليكترونى">
                                </div>
                                <div class="form-group">
                                    <select class="custom-select form-control">
                                        <option selected>نوع الخدمه</option>
                                        <option value="1">التشييد والبناء</option>
                                        <option value="2">اعمال نظافة </option>
                                        <option value="3">اعمال صيانة</option>
                                        <option value="4">خدمات التشغييل ( تاجير عمال - عقود عمالة )</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <input type="text" class="form-control" placeholder="اللوكيشن">
                                </div>
                                <div class="form-group text-center">
                                    <button class="butn mt-3"><span>ارسال</span></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!--End-Menu-->
 
    @yield('content')
    <!--Footer-->
    <footer class="pt-5">
        <div class="container">
            <div class="row">
                <div class="col-md-4">
                    <div class="items about">
                        <h4>@lang('home.about_us')</h4>
                        <p>{{ @substr($info->translations->where('lang_id',$active_lang->id)->first()->content,0, 550).'...' }}</p>
                        <div class="socail">
                            @foreach($setting->social_media_link as $chanel )
                            <a href="{{ $chanel->url }}" target="_blank"><img src="{{ @asset($chanel->icon) }}"></a>
                            @endforeach
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                    <div class="items links">
                        <h4>@lang('home.jobs')</h4>
                        <ul>
                            @foreach($jobs as $job)
                            <li><i class="fas fa-angle-double-left"></i><a href="{{url(LaravelLocalization::getCurrentLocale()).'/job/'.@$job->id.'/'.str_replace(' ', '_', $job->translations->where('lang_id',$active_lang->id)->first()->title )}}">{{ $job->translations->where('lang_id',$active_lang->id)->first()->title }}</a></li>
                            @endforeach
                 
                        </ul>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="items">
                        <h4>@lang('home.contact_info')</h4>
                        <ul>
                            @foreach($setting->phones->take(1) as $phone)
                            <li><i class="fas fa-mobile-alt"></i> {{ @$phone->phone }} </li>
                            @endforeach


                            @foreach($setting->whatsapp->take(1) as $whatsapp)
                            <li><i class="fab fa-whatsapp"></i> {{ @$whatsapp->whatsapp }} </li>
                            @endforeach
                            @foreach($setting->emails->take(1) as $email)
                            <li><i class="far fa-envelope-open"></i> {{ @$email->email  }}</li>
                            @endforeach
                        
                            @foreach($setting->address->take(1) as $address)
                            <li><i class="fas fa-location-arrow"></i>{{ @$address->address_ar }}</li>
                            @endforeach

                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <div class="foot">
        </div>
    </footer>
    <!--End-Footer-->
    <!-- -------------- request ----------------- -->
    <!-- <a class="to-top" data-scroll href="#bazinga" id="scroll-btn">
        <i class="fa fa-arrow-up"></i>
    </a> -->
    <script src="{{asset('/site')}}/js/lib/jquery-3.0.0.min.js"></script>
    <script src="{{asset('/site')}}/js/lib/jquery-migrate-3.0.0.min.js"></script>
    <script src="{{asset('/site')}}/js/lib/popper.min.js"></script>
    <script src="{{asset('/site')}}/js/lib/bootstrap.min.js"></script>
    <script src="{{asset('/site')}}/js/lib/wow.min.js"></script>
    <script src="{{asset('/site')}}/js/lib/jquery.fancybox.js"></script>
    <script src="{{asset('/site')}}/js/lib/jquery.easing-1.3.pack.js"></script>
    <script src="{{asset('/site')}}/js/lib/jquery.mousewheel-3.0.4.pack.js"></script>
    <script src="{{asset('/site')}}/js/lib/owl.carousel.min.js"></script>
    <script src="{{asset('/site')}}/js/lib/smooth-scroll.min.js"></script>
    <script src="{{asset('/site')}}/js/lib/jquery.nicescroll.min.js"></script>
    <script src="{{asset('/site')}}/js/lib/mixitup.min.js"></script>
    <script src="{{asset('/site')}}/js/lib/typed.min.js"></script>
    <script src="{{asset('/site')}}/js/lib/scrollIt.min.js"></script>
    <script src="{{asset('/site')}}/js/lib/jquery.waypoints.min.js"></script>
    <script src="{{asset('/site')}}/js/lib/jquery.counterup.js"></script>
    <script src="{{asset('/site')}}/js/lib/typed.js"></script>
    <script src="{{asset('/site')}}/js/lib/jquery.magnific-popup.min.js"></script>
    <script src="{{asset('/site')}}/js/lib/tilt.jquery.js"></script>
    <script src="{{asset('/site')}}/js/lib/swiper.js"></script>
    <script src="{{asset('/site')}}/js/lib/particles.min.js"></script>
    <script src="{{asset('/site')}}/js/lib/app.js"></script>
    <script src="{{asset('/site')}}/js/main.js"></script>
    @yield('jsCode')
    
</body>

</html>