@extends('front.layouts.main')
@section('meta_tags')
    <title>@lang('home.home') | {{@$setting->translation->title}}</title>
    <meta name='description' itemprop='description' content='{!! @$info->translation->content!!}' />
    <meta name='keywords' content='{!!@$setting->meta_tags!!},{!!@$info->translation->title !!},{!!@$info->mission !!},{!!@$info->goals!!}' />
    <meta property="og:description"content="{{ @$info->translation->content }}" />
    <meta property="og:title"content="@lang('home.home')  | {{@$setting->translation->title}} " />
    <meta property="og:url"content="{{URL::to('/about_us')}}" />
    <meta property="og:site_name"content="{{@$setting->translation->title}}" />
    <meta property="og:image" content="{{URL::to('/').@$setting->logo}}">

    <meta name="twitter:card"content="summary" />
    <meta name="twitter:title"content="@lang('home.home') | {{@$setting->translation->title}}" />
    <meta name="twitter:site"content="@wait" />
@stop
@section('content')
   <!--Header-->
   <header>

        <div class="head-slider owl-carousel owl-theme">
            @if($sliders->count() > 0)
           @foreach($sliders as $slider)
            <div class="items valign" style="background-image: url({{@asset($slider->img)}});">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="content">
                            <h1 class="animated fadeInLeft slow">{{@$slider->translations->where('lang_id',$active_lang->id)->first()->title}}</h1>
                            <p class="animated fadeInUp delay-1s">{{@$slider->translations->where('lang_id',$active_lang->id)->first()->content}}</p>
                            <a href="{{url('/').@$slider->url}}" class="butn light animated zoomIn slow delay-1s"><span>@lang('home.more')</span></a>
                        </div>
                    </div>
                </div>
                <div class="overlay animated fadeInRight"></div>
            </div>
            @endforeach
            @endif
            <!-- <div class="items valign" style="background-image: url({{asset('site')}}/images/head-slide2.jpg);">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="content">
                            <h1 class="animated fadeInLeft slow"> شركة رموز العالمية للمقاولات العامة <span> رمز
                                    الأحترافية</span></h1>
                            <p class="animated fadeInUp delay-1s">عند موافقه العميل المبدئيه على التصميم يتم ازالة هذا
                                النص من التصميم ويتم وضع النصوص
                                النهائية المطلوبة للتصميم ويقول البعض ان وضع النصوص التجريبية بالتصميم.</p>
                            <a href="#" class="butn light animated zoomIn slow delay-1s"><span>أتصل بنا</span></a>
                        </div>
                    </div>
                </div>
                <div class="overlay animated fadeInRight"></div>
            </div> -->

            <!-- <div class="items valign" style="background-image: url({{asset('site')}}/images/head-slide3.jpg);">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="content">
                            <h1 class="animated fadeInLeft slow"> شركة رموز العالمية للمقاولات العامة <span> رمز
                                    الأحترافية</span></h1>
                            <p class="animated fadeInUp delay-1s">عند موافقه العميل المبدئيه على التصميم يتم ازالة هذا
                                النص من التصميم ويتم وضع النصوص
                                النهائية المطلوبة للتصميم ويقول البعض ان وضع النصوص التجريبية بالتصميم.</p>
                            <a href="#" class="butn light animated zoomIn slow delay-1s"><span>أتصل بنا</span></a>
                        </div>
                    </div>
                </div>
                <div class="overlay animated fadeInRight"></div>
            </div> -->

        </div>
    </header>
    <!--End-Header-->
    <!--Contents-->
    <main>
        <!-- --------------------- start about ---------------------- -->
        <section class="about section-padding">
            <div class="container">
                <!-- <div class="section-head text-center">
                    <h2>من نحن</h2>
                </div> -->

                <div class="row">
                    <div class="col-lg-5">
                        <div class="img">
                            <img src="{{asset($info->image)}}" alt="">
                            <img src="{{asset($info->other_img)}}" alt="">
                        </div>
                    </div>

                    <div class="col-lg-7">
                        <div class="info">
                            <h3>{{@$info->translations->where('lang_id',$active_lang->id)->first()->title}}</h3>
                            <div class="text">{{@$info->translations->where('lang_id',$active_lang->id)->first()->content}}</div>
                           

                            <!-- <a href="#" class="butn"><span>المزيد</span></a> -->
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- --------------------- start vision ---------------------- -->
        <section class="vision">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="items">
                            <div class="info">
                                <h4> <i class="far fa-eye"></i> @lang('home.vision')</h4>
                                <p>{{ @$info->translations->where('lang_id',$active_lang->id)->first()->mission }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="items">
                            <div class="info">
                                <h4> <i class="far fa-heart"></i> @lang('home.principles')</h4>
                                <p>{{ @$info->translations->where('lang_id',$active_lang->id)->first()->goals }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- --------------------- start letter ---------------------- -->
        <section class="letter">
            <div class="container">
                <div class="info">
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="r-side">
                                <h5>@lang('home.Chairman_of_Board_of_Directors')</h5>
                                <p>{{ @$info->translations->where('lang_id',$active_lang->id)->first()->who_we_are_working }}</p>
                              
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="img">
                                <img src="{{asset('site')}}/images/about1.jpg" alt="">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="info-back"></div>
            </div>
        </section>
        <!-- --------------------- start portfolio ---------------------- -->
        <section class="portfolio section-padding">
            <div class="container">
                <div class="row">
                    <div class="col-lg-5">
                        <div class="section-head side">
                            <h2>@lang('home.gallery')</h2>
                        </div>
                    </div>

                    <div class="col-lg-7">
                        <!-- portfolio filter taps -->
                        <div class="taps text-right wow zoomIn">
                            <span  class="active"  data-filter="all">@lang('home.all')</span>
                            @foreach($gallerries_categories as $key => $cat_ga)
                            <span data-filter=".{{ @'u'.$cat_ga->id }}">{{ @$cat_ga->translations->where('lang_id',$active_lang->id)->first()->name }}</span>
                            @endforeach
                            {{-- <span data-filter=".tow">أبراج</span> --}}
                            {{-- <span data-filter=".three">مول تجارى</span> --}}
                        </div>
                    </div>
                </div>
                <div class="content">
                    <!-- our projects -->
                    <div class="row no-gutters content wow fadeInUp">
                        @foreach($galleries as $ga_key =>$gallery)
                        <div class="col-lg-4 mix {{ @'u'.$gallery->category_id }}">
                            <div class="items">
                                <div class="img">
                                    <img src="{{@asset($gallery->galleries->first()->image)}}" alt="">
                                </div>
                                <div class="info">
                                    <small>{{ @$gallery->category->translations->where('lang_id',$active_lang->id)->first()->name }}</small>
                                    <h6><a href="{{url(LaravelLocalization::getCurrentLocale()).'/projects/'.$gallery->id.'/'.str_replace(' ','_', $gallery->translations->where('lang_id',$active_lang->id)->first()->title)}}">{{ @$gallery->translations->where('lang_id',$active_lang->id)->first()->title }}</a></h6>
                                </div>
                            </div>
                        </div>
                        @endforeach

                        <!-- end projects -->
                    </div>
                </div>
            </div>
        </section>
        <!-- --------------------- start services ---------------------- -->
        @if($categories->count() > 0)
        <section class="services section-padding">
            <div class="container">
                <div class="section-head side">
                    <h2>@lang('home.services')</h2>
                </div>
                <div class="text">
                    @lang('home.services_header_content')
                </div>
                <div class="content">
                    <div class="row">
                        @foreach($categories as $ser_key => $service)
                        <div class="col-lg-3">
                            <div class="items">
                                <div class="icon">
                                    <img src="{{asset($service->icon)}}" alt="">
                                    <span>{{ @$ser_key+=1 }}</span>
                                </div>
                                @if(LaravelLocalization::getCurrentLocale() == 'en')
                                <h5 title="{{ @$service->translations->where('lang_id',$active_lang->id)->first()->name  }}">{{ @substr($service->translations->where('lang_id',$active_lang->id)->first()->name ,0,19)}}</h5>
                                <p>{{ @substr($service->translations->where('lang_id',$active_lang->id)->first()->content,0,130) }}</p>
                                <a href="{{ url(LaravelLocalization::getCurrentLocale().'/serivce/'.$service->id.'/'.@str_replace(' ','_',$service->translations->where('lang_id',$active_lang->id)->first()->name)) }}">@lang('home.more')<i class="fas fa-chevron-left"></i> </a>

                                @else    
                                <h5 title="{{ @$service->translations->where('lang_id',$active_lang->id)->first()->name  }}">{{ @substr($service->translations->where('lang_id',$active_lang->id)->first()->name ,0,59)}}</h5>
                                <p>{{ @substr($service->translations->where('lang_id',$active_lang->id)->first()->content,0,167) }}</p>
                                <a href="{{ url(LaravelLocalization::getCurrentLocale().'/serivce/'.$service->id.'/'.@str_replace(' ','_',$service->translations->where('lang_id',$active_lang->id)->first()->name)) }}">@lang('home.more')<i class="fas fa-chevron-left"></i> </a>
                                @endif    
                            </div>
                        </div>
                        @endforeach
                  
                    </div>
                </div>
            </div>
        </section>
        @endif
        <!-- --------------------- start news ---------------------- -->
        @if($blogs->count() > 0)
        <section class="news section-padding">
            <div class="container">
                <div class="section-head text-center">
                    <h2> @lang('home.news')</h2>
                </div>
                <div class="content">
                    <!-- our projects -->
                    <div class="row">
                      @foreach($blogs as $blog)
                        <div class="col-lg-4">
                            <div class="items wow zoomIn">
                                <div class="img">
                                    <img src="{{asset($blog->image)}}" alt="">
                                </div>
                                <div class="info">
                                    <div class="date">
                                        {{@Carbon\Carbon::parse($blog->created_at)->diffForHumans()}}
                                        {{-- <span><i class="far fa-user"></i> محمد احمد</span> --}}
                                    </div>
                                    @if(LaravelLocalization::getCurrentLocale() == 'en')
                                    <h5 title="{{ @$blog->translations->where('lang_id',$active_lang->id)->first()->title }}">{{ @substr($blog->translations->where('lang_id',$active_lang->id)->first()->title,0,19) }}</h5>
                                    @else
                                    <h5 title="{{ @$blog->translations->where('lang_id',$active_lang->id)->first()->title }}">{{ @substr($blog->translations->where('lang_id',$active_lang->id)->first()->title,0,59) }}</h5>
                                    @endif
                                    @if(LaravelLocalization::getCurrentLocale() == 'en')

                                    <small>{{ strip_tags(substr($blog->translations->where('lang_id',$active_lang->id)->first()->content ,0,151)) }} <br>
                                    <a href="{{ url(LaravelLocalization::getCurrentLocale().'/article/'.$blog->id) }}">@lang('home.more')</a>
                                    </small>

                                    @else
                                    <small>{{ strip_tags(substr($blog->translations->where('lang_id',$active_lang->id)->first()->content ,0,156)) }} <br>
                                    <a href="{{ url(LaravelLocalization::getCurrentLocale().'/article/'.$blog->id) }}">@lang('home.more')</a>
                                    </small>
                                    @endif
                                </div>
                            </div>
                        </div>
                        @endforeach
                  
                    </div>
                </div>
            </div>
        </section>
        @endif

        <!-- --------------------- start contact ---------------------- -->
        <section class="contact section-padding">
            <div class="container">
                <div class="section-head side">
                    <h2>@lang('home.contactus')</h2>
                </div>
                <div class="content">
                    <div class="row">
                        <div class="col-lg-5">
                            <div class="video">
                                <img src="{{asset('site')}}/images/vid-img.jpg" alt="">
                                <div class="play-button">
                                    <a href="#" data-toggle="modal" data-target="#exampleModalCenter"><img
                                            src="{{asset('site')}}/images/play-button.png" alt=""></a>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-5 offset-lg-1">
                            <div class="contact-form">
                                <h6 class="mb-3">@lang('home.contactus')</h6>
                                 <form action="{{ url('/contactus') }}" method="post">
                                 @csrf
                                 @if ($errors->any())
                                 @foreach ($errors->all() as $error)
                                 <div class="alert alert-danger alert-dismissible">
                                    {{ $error }}
                                    <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                </div>
                                @endforeach
                                @endif
                                @if(Session::has('success'))
                                <div class="alert alert-success alert-dismissible">
                                    <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>{{ Session::get('success') }}
                                </div>
                                @endif
                                    <div class="form-group">
                                         <input type="text" name="name"  class="form-control" value="{{ Request::old('name') }}" placeholder="@lang('home.name')">
                                    </div>
                                    <div class="form-group">
                                        <input type="email" name="email"  class="form-control" value="{{ Request::old('email') }}" id="" placeholder="@lang('home.email')">
                                    </div>
                                    <div class="form-group">
                                       <input type="text" name="subject"  class="form-control" value="{{ Request::old('subject') }}"  placeholder="@lang('home.title')">
                                    </div>
                                    <div class="form-group">
                                        <input type="text" name="phone"  class="form-control" value="{{ Request::old('phone') }}" placeholder="@lang('home.phone')">
                                    </div>
                                    <div class="form-group">
                                       <textarea name="message"  class="form-control" id="" placeholder="@lang('home.message')"> {{ Request::old('message') }} </textarea>
                                    </div>
                                    <div class="form-group text-center">
                                        <button class="butn mt-3"><span>@lang('home.send')</span></button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="info-line">
                        <div class="row">
                            <div class="col-lg-5 text-center">
                                <p>@lang('home.together_we_build__better_future')</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Modal -->
            <div class="modal fade bd-example-modal-lg" id="exampleModalCenter" tabindex="-1" role="dialog"
                aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-body">
                            <iframe width="100%" height="350" src="{{ @$info->vedio_url }}"
                                frameborder="0"
                                allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture"
                                allowfullscreen></iframe>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- --------------------- start mail ---------------------- -->
        @include('front.layouts.subscription_mail')
       
    <!--End-Contents-->
@stop