@extends('front.layouts.main')
@section('meta_tags')
    <title>@lang('home.contactus') | {{@$setting->translation->title}}</title>
    <meta name='description' itemprop='description' content='{!! @$info->translation->content!!}' />
    <meta name='keywords' content='{!!@$setting->meta_tags!!},{!!@$info->translation->title !!},{!!@$info->mission !!},{!!@$info->goals!!}' />
    <meta property="og:description"content="{{ @$info->translation->content }}" />
    <meta property="og:title"content="@lang('home.contactus') | {{@$setting->translation->title}} " />
    <meta property="og:url"content="{{URL::to('/about_us')}}" />
    <meta property="og:site_name"content="{{@$setting->translation->title}}" />
    <meta property="og:image" content="{{URL::to('/').@$setting->logo}}">

    <meta name="twitter:card"content="summary" />
    <meta name="twitter:title"content="@lang('home.contactus')| {{@$setting->translation->title}}" />
    <meta name="twitter:site"content="@wait" />
@stop
@section('content')
  <!--inner-header-->
    <section class="inner-header section-padding">
        <div class="container">
            <div class="section-head text-center">
                <h2>@lang('home.contactus')</h2>
            </div>
        </div>
    </section>
    <!--inner-header-->
   <!--Contents-->
    <main>
        <!-- --------------------- start contact ---------------------- -->
        <section class="contact-pg section-padding mb-5">
            <div class="container">
                <div class="contact-info">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="items">
                                <span>
                                    <img src="{{ asset('site/images/telephone.png') }}" alt="">
                                </span>
                                @foreach($setting->phones as $phone)
                                <p>{{ @$phone->phone }}</p>
                                @endforeach

                            </div>
                        </div>

                        <div class="col-lg-4">
                            <div class="items">
                                <span>
                                    <img src="{{ asset('site/images/gmail.png') }}" alt="">
                                </span>
                                @foreach($setting->emails as $email)
                                    <p>{{ @$email->email  }}</p>
                                @endforeach
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <div class="items">
                                <span>
                                    <img src="{{ asset('site/images/navigator.png') }}" alt="">
                                </span>
                                @foreach($setting->address as $address)
                               
                                 <p>{{ @$address->address_ar }}</p>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
                 <form action="{{ url('/contactus') }}" method="post">
                         @csrf
                         @if ($errors->any())
                         @foreach ($errors->all() as $error)
                         <div class="alert alert-danger alert-dismissible">
                            {{ $error }}
                            <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                        </div>
                        @endforeach
                        @endif
                        @if(Session::has('success'))
                        <div class="alert alert-success alert-dismissible">
                            <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>{{ Session::get('success') }}
                        </div>
                        @endif
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label>@lang('home.name')</label>
                               <input type="text" name="name"  class="form-control" value="{{ Request::old('name') }}" placeholder="@lang('home.name')">
                        </div>
                        <div class="form-group col-md-6">
                            <label> @lang('home.email')</label>
                             <input type="email" name="email"  class="form-control" value="{{ Request::old('email') }}" id="" placeholder="@lang('home.email')">
                        </div>
                         <div class="form-group col-md-6">
                            <label>@lang('home.title')</label>
                              <input type="text" name="subject"  class="form-control" value="{{ Request::old('subject') }}"  placeholder="@lang('home.title')">
                        </div>
                         <div class="form-group col-md-6">
                            <label>@lang('home.phone')</label>
                              <input type="text" name="phone"  class="form-control" value="{{ Request::old('phone') }}" placeholder="@lang('home.phone')">
                        </div>

                        <div class="form-group col-md-12">
                            <label> @lang('home.message')</label>
                            <textarea name="message"  class="form-control" id="" placeholder="@lang('home.message')"> {{ Request::old('message') }} </textarea>
                        </div>
                    </div>
                    <button type="submit" class="butn mt-2"><span>@lang('home.send')</span></button>
                </form>
            </div>
        </section>
        <!-- --------------------- start subscribe ---------------------- -->
        @include('front.layouts.subscription_mail')
    </main>
    <!--End-Contents-->
@stop
