@extends('front.layouts.main')
@section('meta_tags')
    <title>{{ @$category->translations->where('lang_id',$active_lang->id)->first()->name }} | {{@$setting->translation->title}}</title>
    <meta name='description' itemprop='description' content='{!! @$info->translation->content!!}' />
    <meta name='keywords' content='{!!@$setting->meta_tags!!},{!!@$info->translation->title !!},{!!@$info->mission !!},{!!@$info->goals!!}' />
    <meta property="og:description"content="{{ @$info->translation->content }}" />
    <meta property="og:title"content="{{ @$category->translations->where('lang_id',$active_lang->id)->first()->name }} | {{@$setting->translation->title}} " />
    <meta property="og:url"content="{{URL::to('/about_us')}}" />
    <meta property="og:site_name"content="{{@$setting->translation->title}}" />
    <meta property="og:image" content="{{URL::to('/').@$setting->logo}}">

    <meta name="twitter:card"content="summary" />
    <meta name="twitter:title"content="{{ @$category->translations->where('lang_id',$active_lang->id)->first()->name }}| {{@$setting->translation->title}}" />
    <meta name="twitter:site"content="@wait" />
@stop
@section('content')
    <!--Contents-->
    <main>
       
        <!-- --------------------- start services page ---------------------- -->
        <section class="services-pg section-padding">
            <div class="container">
                <h4>{{ @$category->translations->where('lang_id',$active_lang->id)->first()->name }}</h4>
                <div class="text">
                    <strong>{{@$category->translations->where('lang_id',$active_lang->id)->first()->content }}
                    </strong>
                </div>
                <div class="services">
                    <div class="content">
                        <div class="row">
                           @foreach($category->services as $serv_key => $service)
                            <div class="col-lg-3">
                                <div class="items">
                                    <div class="icon">
                                        <img src="{{ @asset($service->img) }}" alt="">
                                        <span>{{ @$serv_key +=1 }}</span>
                                    </div>
                                    <h5>{{ @$service->translations->where('lang_id',$active_lang->id)->first()->title }}</h5>
                                    <p>{{ @$service->translations->where('lang_id',$active_lang->id)->first()->content }}</p>
                                </div>
                            </div>
                            @endforeach

                        </div>
                    </div>
                </div>
            </div>
        </section>
        
       <!-- --------------------- start mail ---------------------- -->
        @include('front.layouts.subscription_mail')
       
    </main>
    <!--End-Contents-->
    
@stop