@extends('front.layouts.main')
@section('meta_tags')
    <title>@lang('home.about_us') | {{@$setting->translation->title}}</title>
    <meta name='description' itemprop='description' content='{!! @$info->translation->content!!}' />
    <meta name='keywords' content='{!!@$setting->meta_tags!!},{!!@$info->translation->title !!},{!!@$info->mission !!},{!!@$info->goals!!}' />
    <meta property="og:description"content="{{ @$info->translation->content }}" />
    <meta property="og:title"content="@lang('home.about_us') | {{@$setting->translation->title}} " />
    <meta property="og:url"content="{{URL::to('/about_us')}}" />
    <meta property="og:site_name"content="{{@$setting->translation->title}}" />
    <meta property="og:image" content="{{URL::to('/').@$setting->logo}}">

    <meta name="twitter:card"content="summary" />
    <meta name="twitter:title"content="@lang('home.about_us')| {{@$setting->translation->title}}" />
    <meta name="twitter:site"content="@wait" />
@stop
@section('content')
  <!--inner-header-->
    <section class="inner-header section-padding">
        <div class="container">
            <div class="section-head text-center">
                <h2>@lang('home.about_us')</h2>
            </div>
        </div>
    </section>
    <!--inner-header-->
    <!--Contents-->
    <main>
        <!-- --------------------- start about ---------------------- -->
        <section class="about section-padding">
            <div class="container">
                <!-- <div class="section-head text-center">
                    <h2>من نحن</h2>
                </div> -->

                <div class="row">
                    <div class="col-lg-5">
                        <div class="img">
                             <img src="{{asset($info->image)}}" alt="">
                            <img src="{{asset($info->other_img)}}" alt="">
                        </div>
                    </div>

                    <div class="col-lg-7">
                        <div class="info">
                            <h3>{{ @$info->translations->where('lang_id',$active_lang->id)->first()->title }}</h3>
                            <div class="text">
                                {{ @$info->translations->where('lang_id',$active_lang->id)->first()->content }}
                            </div>
                           

                            <!-- <a href="#" class="butn"><span>المزيد</span></a> -->
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- --------------------- start letter ---------------------- -->
        <section class="letter">
            <div class="container">
                <div class="info">
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="r-side">
                                <h5>@lang('home.Chairman_of_Board_of_Directors')</h5>
                                <p>{{ @$info->translations->where('lang_id',$active_lang->id)->first()->who_we_are_working }}</p>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="img">
                                <img src="{{asset('site')}}/images/about1.jpg" alt="">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="info-back"></div>
            </div>
        </section>
        <!-- --------------------- start vision ---------------------- -->
        <section class="vision pt-5">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="items">
                            <div class="info">
                                <h4> <i class="far fa-eye"></i>  @lang('home.vision')</h4>
                                <p>{{ @$info->translations->where('lang_id',$active_lang->id)->first()->mission }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="items">
                            <div class="info">
                                <h4> <i class="far fa-heart"></i>  @lang('home.principles')</h4>
                                <p>{{ @$info->translations->where('lang_id',$active_lang->id)->first()->goals }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

          <!-- --------------------- start mail ---------------------- -->
        @include('front.layouts.subscription_mail')
       
    </main>
    <!--End-Contents-->
@stop