@extends('front.layouts.main')
@section('meta_tags')
    <title>تسجيل الدخول | {{@$setting->translation->title}}</title>
    <meta name='description' itemprop='description' content='{!! @$info->translation->content!!}' />
    <meta name='keywords' content='{!!@$setting->meta_tags!!},{!!@$info->translation->title !!},{!!@$info->mission !!},{!!@$info->goals!!}' />
    <meta property="og:description"content="{{ @$info->translation->content }}" />
    <meta property="og:title"content="تسجيل الدخول  | {{@$setting->translation->title}} " />
    <meta property="og:url"content="{{URL::to('/about_us')}}" />
    <meta property="og:site_name"content="{{@$setting->translation->title}}" />
    <meta property="og:image" content="{{URL::to('/').@$setting->logo}}">

    <meta name="twitter:card"content="summary" />
    <meta name="twitter:title"content="تسجيل الدخول  | {{@$setting->translation->title}}" />
    <meta name="twitter:site"content="@wait" />
@stop
@section('content')

<!--Contents-->
    <main class="inner-pages">
        <div class="inner-header">
            <div class="page-title">
                <div class="container">
                    <h5 class=""><a href="#">@lang('home.home')</a> / @lang('home.login')</h5>
                </div>
            </div>
        </div>
        <!-- ======================== start about =========================== -->
        <section class="contact section-padding">
            <div class="container">
                <div class="section-head text-center">
                    <h2> @lang('home.login')</h2>
                </div>
                <div class="login">
                    <div class="row">
                        <div class="col-lg-6 offset-lg-3">
                            <div class="contact-form contact-box">
                                    <form method="POST" action="{{ route('login') }}">
                                    @csrf
                                        <div class="row">
                                            <div class="col-md-12">
                                                <input type="email" class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}"  name="email" value="{{ old('email') }}" placeholder="@lang('home.email')">
                                                @if ($errors->has('email'))
                                                <span class="invalid-feedback " role="alert">
                                                    <strong class="text-danger">{{ $errors->first('email') }}</strong>
                                                </span>
                                                @endif
                                            </div>
                                            <div class="col-md-12">
                                                <input type="password" class="form-control{{ $errors->has('password') ? ' is-invalid' : '' }}" name="password" placeholder="@lang('home.password')">
                                                @if ($errors->has('password'))
                                                <span class="invalid-feedback " role="alert">
                                                    <strong class="text-danger">{{ $errors->first('password') }}</strong>
                                                </span>
                                                @endif
                                            </div>
                                            <div class="col-md-12  text-center">
                                                <button type="submit" class="butn"> @lang('home.login')</button>
                                            </div>
                                        </div>
                                    </form>
                                    <div class="text hvcont">
                                        @lang("home.you_don't_have_an_account") <a href="{{ URL::to('/register') }}">@lang('home.create_new') </a> <br>
                                         @if (Route::has('password.request'))
                                        @lang('home.reset_password') <a  href="{{ url(LaravelLocalization::getCurrentLocale()).'/register' }}">@lang('home.forget_password')</a>
                                         @endif
                                    </div>
                                    
                                </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End login  ========-->
    </main>
@stop