<?php



use Illuminate\Support\Facades\Schema;

use Illuminate\Database\Schema\Blueprint;

use Illuminate\Database\Migrations\Migration;



class CreateAdsTable extends Migration

{

    /**

     * Run the migrations.

     *

     * @return void

     */

    public function up()

    {

        Schema::create('ads', function (Blueprint $table) {

            $table->increments('id');

            $table->string('price')->nullable();

            $table->string('url')->nullable();

            $table->string('address')->nullable();

            $table->string('lat')->nullable();

            $table->string('long')->nullable();

            $table->longText('map');

            $table->string('meta_tags')->nullable();

            $table->enum('status',['show','hide']);

            $table->enum('type_ad',['none','own','rent','purchase','other']);



            $table->unsignedInteger('category_id');

            $table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');

        



            $table->unsignedBigInteger('user_id');

            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            

            $table->bigInteger('purpose_id')->unsigned();

            $table->foreign('purpose_id')->references('id')->on('ad_purposes')->onDelete('cascade');

            

            $table->string('share_link')->nullable();

            $table->string('vedio')->nullable();

            $table->string('space')->nullabe();

            $table->string('bed_room')->nullabe();

            $table->string('bathroom')->nullabe();

            $table->string('parking')->nullabe();

            $table->softDeletes();

            $table->timestamps();

        });



    }



    /**

     * Reverse the migrations.

     *

     * @return void

     */

    public function down()

    {

        Schema::dropIfExists('ads');

    }

}

