<?php



use Illuminate\Support\Facades\Schema;

use Illuminate\Database\Schema\Blueprint;

use Illuminate\Database\Migrations\Migration;



class CreateCategoryTranslationsTable extends Migration

{

    /**

     * Run the migrations.

     *

     * @return void

     */

    public function up()

    {

        Schema::create('category_translations', function (Blueprint $table) {

            $table->increments('id');

            $table->string('name')->nullable();

            $table->unsignedInteger('category_id');

            $table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');

            $table->unsignedInteger('lang_id');

            $table->foreign('lang_id')->references('id')->on('setting_langs')->onDelete('cascade');

            $table->softDeletes();

            $table->timestamps();

        });

    }



    /**

     * Reverse the migrations.

     *

     * @return void

     */

    public function down()

    {

        Schema::dropIfExists('category_translations');

    }

}

