<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class TestMonials extends Model
{
    protected $table= "test_monials";
    protected $fillable = [
		    	'rate',
		    	'title',
		    	'content',
		    	'category_id',
		    	'image'
    ];


	public function category()
	{
        return $this->belongsTo('App\ReasonsReport','category_id');		
	}

	public function translations()
	{
		return $this->hasMany('App\TestmonialsTranslation','testmonial_id');
	}

	public function galleries()
	{
		return $this->hasMany('App\TestmonialsGallery','testmonial_id');
	}
}
