<?php

namespace App\Http\Resources\Api;

use Illuminate\Http\Resources\Json\JsonResource;
use  App\Http\Resources\Api\SettingEmailsResource;
use  App\Http\Resources\Api\SettingAddressResource;
use  App\Http\Resources\Api\SettingPhonesResource;
use  App\Http\Resources\Api\SettingWhatsAppResource;
class CompanyInfoResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        // return parent::toArray($request);
        return [
            'logo'=>asset($this->logo),
            'app_name'=>$this->translations->first()->title,
            'description'=>$this->translations->first()->content,
            'address'=>  SettingAddressResource::collection($this->address),
            'emails'=>  SettingEmailsResource::collection($this->emails),
            'phones'=>  SettingPhonesResource::collection($this->phones),
            'whatsapp'=>  SettingWhatsAppResource::collection($this->whatsapp),
            'social_media'=>  SettingSocialMediaResource::collection($this->social_media_link),
        ];
    }
}
