<?php

namespace App\Http\Resources\Api;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\Api\SubCategoriesResource;
class CategoriesResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'=>$this->id,
            'icon'=>asset($this->icon),
            'name'=>$this->translations->first()->name,
            'sub_categories'=>SubCategoriesResource::collection($this->sub_categories) 
        ];

    }
}
