<?php

namespace App\Http\Resources\Api;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\Api\AdsImagesResource;
class AdsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'=>$this->id,
            'title'=>($this->translations->count() > 0) ? $this->translations->first()->title : '' ,
            'content'=>($this->translations->count() > 0) ? $this->translations->first()->content : '' ,
            'address'=>$this->address,
            'lat'=>$this->lat,
            'long'=>$this->long,
            'price'=>$this->price,
            'space'=>($this->space != null) ? $this->space : '',
            'bed_room'=>($this->bed_room != null) ? $this->bed_room : '',
            'bathroom'=>($this->bathroom != null) ? $this->bathroom : '',
            'parking'=>($this->parking != null) ? $this->parking : '',
            'type_ad'=>$this->type_ad,
            'status'=>$this->status,
            'image'=> ($this->images->count() > 0 ) ? asset($this->images->first()->image) : asset('img/no_image.png'),
            'images'=> AdsImagesResource::collection($this->images),
            'category'=>[
                'id'=>$this->category->id,
                'name'=>$this->category->category_translation->name,
                'icon'=>asset($this->category->icon)
            ],
            'auther'=>[
                'fname'=>$this->user->fname,
                'lname'=>$this->user->lname,
                'avtar'=>asset($this->user->image)
            ],

        ];
         
    }
}
