<?php

namespace App\Http\Controllers\Api\Auth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\Api\UserInfoResource;
use App\user;
use Validator;
use Response;
use Auth;

class ProfileController extends Controller
{

	public function validation($request)
    {
         $validator = Validator::make($request, [
            'fname'=>'required',
            'lname'=>'required',
            'email'=>'required|unique:users,id,'.Auth::id(),
            'country_id'=>'required|numeric',
            'phone'=>'required|numeric',
            // 'image'=>'mimes:jpeg,jpg,png,gif',
            'password'=> 'min:6',
        ]);

        if ($validator->fails()) {
            $msg = $validator->errors()->first();
            $response = [
                    'success'=>FALSE,
                    'message'=>$msg,
                    'data'=>[]
                ];   
               return $response;  
        }
    }


    public function update(Request $request)
    {
    	$validation = $this->validation($request->all());
      
        if($validation != null){
            return Response::json($validation,400) ; 
        }


    	$update = User::find(Auth::id())->update([
            'fname'=>$request->fname,
            'lname'=>$request->lname,
            'email'=>$request->email,
            'country_id'=>$request->country_id,
            'phone'=>$request->phone,
        ]);

        if($request->has('password')){
            User::find(Auth::id())->update([
                'password'=>bcrypt($request->password),
            ]);
        }



        if ($request->has('image')) {
            $time = (time()* rand(1, 99));
            $fullname = $time . '.' . $request->extention;
            $image = "data:image/".$request->extention.";base64,".$request->input('image');

            $img = substr($image, strpos($image, ",")+1);
            
            $binary  = base64_decode($img);

            file_put_contents( public_path().'/uploads/images/users/'. $fullname, base64_decode(explode(',',$image)[1]));

            $image ='/uploads/images/users/'.$fullname;
            
            $update_user = User::where('id',Auth::id())->update(['image'=>$image]);
        }

        $info = new  UserInfoResource(User::find(Auth::id()));

        $msg = 'success';
        $response = [
                'message'=>$msg,
                'success'=>TRUE,
                'data'=>$info,                
            ];   
        return Response::json($response,200); 

    }
}
