<?php

namespace App\Http\Controllers\Api\Auth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\Api\UserInfoResource;
use Carbon\Carbon;
use App\User;
use Validator;
use Response;
use Hash;
use Mail;


class ForgetPassword extends Controller
{
	 public function validation($request,$functionName)
    {
    	if ($functionName == 'FirstStep') {
	        $validator = Validator::make($request, [
           		'email'=>'required'
	        ]);
    	}elseif($functionName == 'VerificationCode'){
    		$validator = Validator::make($request, [
	            'code'=>'required'
	        ]);
    	}elseif($functionName == 'ResetPassword'){
    		$validator = Validator::make($request, [
	            'password'=>'required|confirmed|min:8',
	        ]);
    	}


        if ($validator->fails()) {
            $msg = $validator->errors()->first();
            $response = [
                    'success'=>FALSE,
                    'message'=>$msg,
                    'data'=>[]
                ];   
               return $response;  
        }
    }
	/*
    *******************
    *check email user *
    *******************
    */
    public function FirstStep(Request $request)
    {
  		
  		$validation = $this->validation($request->all(),'FirstStep');
      
        if($validation != null){
            return Response::json($validation,400) ; 
        }

        $find_user = User::where('email',$request->get('email'))
                    // ->whereIn('type_user', array('user'))
                    ->get();

        if(count($find_user) > 0){
        	  $find_user = User::where('email',$request->get('email'))
                    // ->whereIn('type_user', array('user'))
                    ->first();

            $generate_code = substr(md5(rand()),0,4);
            $token = md5(rand());
            $update_user = User::find($find_user->id)->update([
                'reset_code'=>$generate_code,
                'user_token'=>$token
            ]);
            
            Mail::send('email.reset_code', [
            	'username'=>$find_user->fname,
            	'generate_code'=>$generate_code,
            	'email'=>$find_user->email,
            	'find_user'=>$find_user
            ], function ($message) use ($find_user,$generate_code)
            {
               $message->from('no-reply@alyomhost.net', 'Support.alyomhost.net');
               $message->to($find_user->email)->subject('Forget password');
           });
         
            $msg = 'من فضلك قم بإدخال الرمز المرسل من خلال البريد الالكتروني!';
            $response = [
                    'success'=>TRUE,
                    'message'=>$msg,
                    'token'=>$token,
                    'data'=>[]
                ];   		
    		return Response::json($response,200);
        }else{
            //user user info  if not found will see this message
            $msg =  'البريد غير موجود!';
			$response = ['success'=>FaLSE,
	                    'message'=>$msg,
	                    'data'=>[]
                ];			
    		return Response::json($response,400);
        }

    }

    /*
    ***************
    * Check Owner *
    ***************
    */ 
    public function VerificationCode(Request $request,$token)
    { 
 
 	    $validation = $this->validation($request->all(),'VerificationCode');
      
        if($validation != null){
            return Response::json($validation,400) ; 
        }
        $find_user = User::where('user_token',$token)->first();
		if ($find_user == NULL) {
			$msg =  'بيانات المستخدم غير موجوده من فضلك تأكد من الرمز التعريفي للمستخدم!';
			$response = ['success'=>FaLSE,
	                    'message'=>$msg,
	                    'data'=>[]
                ];			
    		return Response::json($response,400);


		}else{
			//start find user
	        if($find_user->reset_code == $request->get('code'))
	        {
	            $update_user = User::find($find_user->id)->update([
	                'reset_code'=>'',
	            ]);
	  
				$msg =  'يقيمه صالحه .. تهانينا!';
				$response = ['success'=>TRUE,
		                    'message'=>$msg,
		                    'token'=>$token,
		                    'data'=>[]
	                ];			
	    		return Response::json($response,200);
	        }else{
	           
				$msg =  'قيمه خاطئه .. نأسف!';
				$response = ['success'=>FALSE,
		                    'message'=>$msg,
		                    'token'=>$token,
		                    'data'=>[]
	                ];			
	    		return Response::json($response,400);

	        }
	        //end find user
		}//end else case check user token

    }

    /*
    ******************
    * Reset Password *
    ******************
    */
    public function ResetPassword(Request $request, $token)
    {
 
 		$validation = $this->validation($request->all(),'ResetPassword');
      
        if($validation != null){
            return Response::json($validation,422) ; 
        }
        if (User::where('user_token',$token)->count() > 0){
        $find_user = User::where('user_token',$token)->first();
        $update_password  = User::find($find_user->id)->update([
            'password'=>bcrypt($request->get('password'))
        ]);

        $tokenResult = $find_user->createToken('Personal Access Token');
        $token_user = $tokenResult->token;

    	$msg = 'تم تحديث كلمة المرور';
		$response = [
            'success'=>TRUE,
	        'message'=>$msg,
	        'data'=>[
                'user'=>new  UserInfoResource(User::find($find_user->id)),
                'access_token' => $tokenResult->accessToken,
                'token_type' => 'Bearer',
                'expires_at' => Carbon::parse(
                    	$tokenResult->token->expires_at
               		)->toDateTimeString()
                ]
    ];
		
        }else{
    	

		$msg = 'خطأ في التوكن الخاصه بالمستخدم';
				$response = [
						'success'=>FALSE,
	                    'message'=>$msg,
	                    'token'=>[],
	                    'data'=>[]
	                ];			
    	}
			return Response::json($response,400);
	}
 
}
