<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Ads,App\AdsTranslations,App\AdsImages;
use App\Http\Resources\Api\AdsResource;
use Illuminate\Validation\Rule;
use App\Http\Controllers\ImagesController;
use Validator;
use Response;
use App\Category;
use Auth;

class AdsController extends Controller
{
    public function adsByCategories($category_id,Request $request)
    {

        $ads = Ads::where('category_id',$category_id)->where('status','show');

        if ($request->has('type_ad')) { //case 1

            if ($request->type_ad == '') { //case 1 in 1
               $ads = $ads->where('category_id',$category_id);
            }else{//case 2 in 1
                $ads = $ads->where('category_id',$category_id)->where('type_ad',$request->type_ad);
            }

        }else{//case 2
            $ads = $ads->where('category_id',$category_id);

        }
        $category = Category::find($category_id);
        $ads = AdsResource::collection($ads->paginate(10));


    	$msg= 'success'; 
    	$response = [
                    'success'=>TRUE,
                    'message'=>$msg,
                    'data'=>$ads,
                    'count_ads' => $ads->count(),
		            'total_pages' => $ads->total(),
		            'prev_link'  => $ads->previousPageUrl(),
		            'next_link'  => $ads->nextPageUrl()
                ];   
        return Response::json($response,200) ; 
    }

     public function adsByAuth()
    {
    	$ads = AdsResource::collection(Ads::where('user_id',Auth::id())->where('status','show')->orderBy('created_at','DESC')->paginate(10));
    	$msg= 'success'; 
    	$response = [
                    'success'=>TRUE,
                    'message'=>$msg,
                    'data'=>$ads,
                    'count_ads' => $ads->count(),
		            'total_pages' => $ads->total(),
		            'prev_link'  => $ads->previousPageUrl(),
		            'next_link'  => $ads->nextPageUrl()
                ];   
        return Response::json($response,200) ; 
    }


    public function show($id)
    {

    	if (Ads::find($id) == null) {
			$msg= 'NOT FOUND'; 
	    	$response = [
	                    'success'=>false,
	                    'message'=>$msg,
	                    'data'=>[],
	                ];   
	        return Response::json($response,404) ; 
		}
    	$ad= new AdsResource(Ads::find($id));
		$msg= 'success'; 
    	$response = [
                    'success'=>TRUE,
                    'message'=>$msg,
                    'data'=>$ad,
                ];   
        return Response::json($response,200) ; 
    }

    public function validation($request)
    {
         $validator = Validator::make($request, [
               'category_id'=>'required',
                'title.*'=>'required',
                'content.*'=>'required',
                'address'=>'required',
                'lat'=>'required',
                'long'=>'required',
                // // 'images.*'=>'required|mimes:jpeg,bmp,png,jpg',
                // 'images.*'=>'required',
                'price'=>'required',
                'add_type'=>[
                        'required',
                        Rule::in(['own','rent','purchase','other']),
                        ],
                // 'map'=>'required'
        ]);

        if ($validator->fails()) {
            $msg = $validator->errors()->first();
            $response = [
                    'success'=>FALSE,
                    'message'=>$msg,
                    'data'=>[]
                ];   
               return $response;  
        }
    }

    public function store(Request $request)
    {
    	$validation = $this->validation($request->all());
      
        if($validation != null){
            return Response::json($validation,400) ; 
        }

    	if ($request->sub_categoris != null) {
			$category_id = $request->sub_categoris;
		}else{
			$category_id = $request->category_id;
		}

		$create_ad = Ads::create([
						'category_id'=>$category_id,
						'price'=>$request->price,
						'user_id'=>Auth::id(),
						'url'=>' ',
						'map'=>' ',
						'meta_tags'=>' ',
						'status'=>'show',
						'address'=>$request->address,
                        'lat'=>$request->lat,
                        'long'=>$request->long,
                        'space'=>$request->space,
						'bed_room'=>$request->bed_room,
						'bathroom'=>$request->bathroom,
						'parking'=>$request->parking,
					]);//end save base info
		

			$translation =	AdsTranslations::create([
									'ad_id'=>$create_ad->id,
									'lang_id'=>1,
									'title'=>$request->title,
									'address'=>' ',
									'content'=>$request->content,
								]);

		if ($request->has('images')) {
			$set_images_path_db = [];

			foreach ($request->images as $key => $file) {

                $time = (time()* rand(1, 99));
                $fullname = $time . '.' . $request->extention[$key];
                $image = "data:image/".$request->extention[$key].";base64,".$file;

                $img = substr($image, strpos($image, ",")+1);
                
                $binary  = base64_decode($img);

               $move =  file_put_contents( public_path().'/uploads/images/products/'. $fullname, base64_decode(explode(',',$image)[1]));

                $image ='/uploads/images/products/'.$fullname;

				$set_images_path_db = AdsImages::create([
					'image'=>$image,
					'ad_id'=>$create_ad->id
				]);
			}//end loop save images
		}//end images case when we have images
		$msg= 'success'; 
    	$ad= new AdsResource(Ads::find($create_ad->id));
    	$response = [
                    'success'=>TRUE,
                    'message'=>$msg,
                    'data'=>$ad,
                ];   
        return Response::json($response,200) ; 
    }


   public function update($id,Request $request)
   {
   		$validation = $this->validation($request->all());
      
        if($validation != null){
            return Response::json($validation,400) ; 
        }

        if ($request->sub_categoris != null) {
			$category_id = $request->sub_categoris;
		}else{
			$category_id = $request->category_id;
		}

		$update  = Ads::find($id)->update([
						'category_id'=>$category_id,
						'user_id'=>Auth::id(),
						'price'=>$request->price,
						'url'=>' ',
						'map'=>' ',
						'meta_tags'=>' ',
                        'address'=>$request->address,
                        'lat'=>$request->lat,
                        'long'=>$request->long,
						'type_ad'=>$request->add_type,
						'space'=>$request->space,
						'bed_room'=>$request->bed_room,
						'bathroom'=>$request->bathroom,
						'parking'=>$request->parking,
					]);//end save base info

		AdsTranslations::where('ad_id',$id)->delete();
		$translation =	AdsTranslations::create([
								'ad_id'=>$id,
								'lang_id'=>1,
								'title'=>$request->title,
								'address'=>' ',
								'content'=>$request->content,
							]);
	
		if ($request->has('images')) {
			$set_images_path_db = [];
		

			foreach ($request->images as $key => $file) {
                if ($file != null) {
                    $time = (time()* rand(1, 99));
                    $fullname = $time . '.' . $request->extention[$key];
                    $image = "data:image/".$request->extention[$key].";base64,".$file;
                    $img = substr($image, strpos($image, ",")+1);
                    
                    $binary  = base64_decode($img);

                   $move =  file_put_contents( public_path().'/uploads/images/products/'. $fullname, base64_decode(explode(',',$image)[1]));

                    $image ='/uploads/images/products/'.$fullname;
                    
    				$set_images_path_db = AdsImages::create([
    					'image'=>$image,
    					'ad_id'=>$id
    				]);
                }
			}//end loop save images
		}//end images case when we have images


        $msg= 'success'; 
    	$ad= new AdsResource(Ads::find($id));
    	$response = [
                    'success'=>TRUE,
                    'message'=>$msg,
                    'data'=>$ad,
                ];   
        return Response::json($response,200) ; 

   }


   public function destoyImage($image_id)
   {
   		if (AdsImages::find($image_id) == null) {
			$msg= 'NOT FOUND'; 
	    	$response = [
	                    'success'=>false,
	                    'message'=>$msg,
	                    'data'=>[],
	                ];   
	        return Response::json($response,404) ; 
		}

   		AdsImages::destroy($image_id);
   	    $msg = 'success'; 
    	$response = [
                    'success'=>TRUE,
                    'message'=>$msg,
                    'data'=>[],
                ];   
        return Response::json($response,200) ; 
   }

    public function destoyAd($ad_id)
    {
   		if (Ads::find($ad_id) == null) {
			$msg= 'NOT FOUND'; 
	    	$response = [
	                    'success'=>false,
	                    'message'=>$msg,
	                    'data'=>[],
	                ];   
	        return Response::json($response,404) ; 
		}
   		Ads::where('user_id',Auth::id())->where('id',$ad_id)->delete($ad_id);
   	    $msg= 'success'; 
    	$response = [
                    'success'=>TRUE,
                    'message'=>$msg,
                    'data'=>[],
                ];   
        return Response::json($response,200) ; 
   }

}
