<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\TestMonials,App\ReasonsReport;
use App\TestmonialsTranslation,App\TestmonialsGallery;
use App\Http\Requests\Admin\TestmonialsRequest;
use Jenssegers\Agent\Agent;
use App\Helpers\DoFire;
use Session;
use Auth;

class TestmonialsController extends Controller
{
    public $view = 'panel.testmonials';
    
    public function __construct(
        TestMonials $testmonials,
        TestmonialsTranslation $translation,
        TestmonialsGallery $gallery
    )
	{
        $this->testmonials = $testmonials;
        $this->translation = $translation;
        $this->gallery = $gallery;

	}	

	public function index(Request $request)
    {
        $testmonials = $this->testmonials->with('translations')->get();
        $agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_browse_testmonials','text'=>'Brwose view Testmonial list','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),$testmonials,$request->ipinfo);
		return view($this->view.'.index',compact('testmonials'));		

    }

    public function create(Request $request)
    {
        $agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $categories = ReasonsReport::orderBy('created_at','DESC')->get();
        $info = [];
        $data = ['key'=>'dashboard_browse_view_create_new_testmonials','text'=>'Brwose View Create New Testmonials','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);
        
		return view($this->view.'.create',compact('categories','info'));		
    }    


    public function store(TestmonialsRequest $request)
    {
   

         $testmonial = $this->testmonials->create([
                        'category_id'=>$request->category_id,
                      
                    ]);

         foreach ($request->lang as $key => $lang) {
            $translation = $this->translation->create([
                'title'=>$request->title[$key],
                'content'=>$request->content[$key],
                'lang_id'=>$lang,
                'testmonial_id'=>$testmonial->id
            ]);
        }
     
        foreach ($request->image as $img_ket => $image) {
            $file = $image; 
            $time = str_replace('/', 5, str_replace('.', 'f', bcrypt(time().rand(0,8515) )));
            $ext = $file->getClientOriginalExtension();
            $fullname = $time . '.' . $ext;
            $move = $file->move(public_path() .'/uploads/images/testmonials', $fullname);
            $path ='/uploads/images/testmonials';
            $image = $path.'/'.$fullname;
            $this->gallery->create([
                'testmonial_id'=>$testmonial->id,
                'image'=>$image,
            ]);
        }
        $agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_browse_create_new_testmonials','text'=>'Brwose Create New Testmonials','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),$testmonial,$request->ipinfo);

        session::flash('success',trans('home.message_success'));
        return redirect()->back();
    }

        public function edit(Request $request,$id)
    {
        $agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_browse_view_create_new_testmonials','text'=>'Brwose View Create New Testmonials','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);
        $categories = Category::all(); 
        $info = $this->testmonials->find($id);

        if ($info == null) {
			return abort(404);
		}
			
		return view($this->view.'.edit',compact('categories','info'));		
    }   

    public function show($id)
    {
        # code...
    }


    public function update($id,TestmonialsRequest $request)
     {
     	 if ($this->testmonials->find($id) == null) {
			return abort(404);
		}
   //   	if($request->hasFile('image')){
   //          $file =$request->file('image'); 
			// $time = time();
			// $ext = $file->getClientOriginalExtension();
			// $fullname = $time . '.' . $ext;
   //          $move = $file->move(public_path() .'/uploads/images/testmonials', $fullname);
   //          $path ='/uploads/images/testmonials';
   //          $image = $path.'/'.$fullname;
   //          $this->testmonials->find($id)->update([
   //              'image'=>$image
   //          ]);
   //      }
       

        $this->testmonials->find($id)->update([
                        'category_id'=>$request->category_id,
                        // 'title'=>$request->title,
                        // 'content'=>$request->content,
                    ]);

        $this->translation->where('testmonial_id',$id)->delete();
          foreach ($request->lang as $key => $lang) {
            $translation = $this->translation->create([
                'title'=>$request->title[$key],
                'content'=>$request->content[$key],
                'lang_id'=>$lang,
                'testmonial_id'=>$testmonial->id
            ]);
        }
     
        foreach ($request->image as $img_ket => $image) {
            $file = $image; 
            $time = time();
            $ext = $file->getClientOriginalExtension();
            $fullname = $time . '.' . $ext;
            $move = $file->move(public_path() .'/uploads/images/testmonials', $fullname);
            $path ='/uploads/images/testmonials';
            $image = $path.'/'.$fullname;
            $this->gallery->create([
                'testmonial_id'=>$testmonial->id,
                'image'=>$image,
            ]);
        }
     
        $agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_browse_create_new_testmonials','text'=>'Brwose Create New Testmonials','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),$this->testmonials->find($id),$request->ipinfo);

        session::flash('success',trans('home.message_success'));
        return redirect()->back();
     } 

    public function destroy($id,Request $request)
    {

       $agent = new Agent();
       $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
       $data = ['key'=>'dashboard_destroy_testmonial_id'.$id,'text'=>'Destroy testmonial Info','browser'=>$agent];
       $info  = $this->testmonials->find($id);

           DoFire::MK_REPORT($data,Auth::id(),$info,$request->ipinfo);
           $this->testmonials->destroy($id);
        Session::flash('success',trans('home.message_success'));
        return redirect()->back();  
    }


    public function destroyAll(TestmonialsRequest $request)
    {

       $agent = new Agent();
       $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
       $data = ['key'=>'dashboard_destroy_testmonial_ids_['.json_encode($request->ids).']','text'=>'Destroy selected testmonial Info','browser'=>$agent];

        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);

        if ($request->has('ids')) {
            $this->testmonials->wherein('id',$request->ids)->delete();
        }else{
        $this->testmonials->truncate();
        }
        Session::flash('success',trans('home.message_success'));
        return redirect()->back();  
    }


}
