<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\jobs,App\jobsTranslations;
use Jenssegers\Agent\Agent;
use App\Helpers\DoFire;
use App\Http\Controllers\ImagesController;
use App\Http\Requests\Admin\JobsRequest;
use Session;
use Auth;

class JobsController extends Controller
{
    public $view = 'panel.jobs';
    
    public function __construct(jobs $jobs,jobsTranslations $translation)
	{
        $this->jobs = $jobs;
        $this->translation = $translation;
	}	

	public function index(Request $request)
    {
        $jobs = $this->jobs->with('translations')->get();
        // dd($jobs);
        $agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_browse_jobs','text'=>'Brwose view Jpbs list','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),$jobs,$request->ipinfo);
		return view($this->view.'.index',compact('jobs'));		

    }

    public function create(Request $request)
    {
        $agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $job = [];
        $data = ['key'=>'dashboard_browse_view_create_new_jobs','text'=>'Brwose View Create New job','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);
        
		return view($this->view.'.create',compact('job'));		
    }    


    public function store(JobsRequest $request)
    {
        if($request->hasFile('image')){
            $file =$request->file('image'); 
			$time = time();
			$ext = $file->getClientOriginalExtension();
			$fullname = $time . '.' . $ext;
            $move = $file->move(public_path() .'/uploads/images/jobs', $fullname);
            $path ='/uploads/images/jobs';
            $image = $path.'/'.$fullname;
        }else{
            $image = '/img/avatar.png';
        }

        $create = $this->jobs->create([
                    'image'=>$image
                ]);
                // dd($request->all());
        
        if ($request->has('lang')) {
            $translation = [];
            foreach ($request->lang as $key => $lang) {
            $translation =	$this->translation->create([
                                    'job_id'=>$create->id,
                                    'lang_id'=>$lang,
                                    'title'=>$request->title[$key],
                                    'content'=>$request->content[$key],
                                ]);
            }//end loop save translation
        }//end languages when we lave lang
        $agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_browse_create_new_job','text'=>'Brwose Create New job','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),$create,$request->ipinfo);

        session::flash('success',trans('home.message_success'));
        return redirect()->back();
    }

        public function edit(Request $request,$id)
    {
        $agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_browse_view_create_new_job','text'=>'Brwose View Create New job','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);
        $info = $this->jobs->find($id);

        if ($info == null) {
			return abort(404);
		}
			
		return view($this->view.'.edit',compact('info'));		
    }   

    public function show($id)
    {
        # code...
    }


    public function update($id,TestmonialsRequest $request)
     {
     	 if ($this->jobs->find($id) == null) {
			return abort(404);
		}
     	if($request->hasFile('image')){
            $file =$request->file('image'); 
			$time = time();
			$ext = $file->getClientOriginalExtension();
			$fullname = $time . '.' . $ext;
            $move = $file->move(public_path() .'/uploads/images/jobs', $fullname);
            $path ='/uploads/images/jobs';
            $image = $path.'/'.$fullname;
            $this->jobs->find($id)->update([
                'image'=>$image
            ]);
        }
       

     
        $agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_browse_create_new_jobs','text'=>'Brwose Create New jobs','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),$this->jobs->find($id),$request->ipinfo);

        session::flash('success',trans('home.message_success'));
        return redirect()->back();
     } 

    public function destroy($id,Request $request)
    {

       $agent = new Agent();
       $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
       $data = ['key'=>'dashboard_destroy_jobs_id'.$id,'text'=>'Destroy jobs Info','browser'=>$agent];
       $info  = $this->jobs->find($id);

        DoFire::MK_REPORT($data,Auth::id(),$info,$request->ipinfo);
        $this->jobs->destroy($id);
        Session::flash('success',trans('home.message_success'));
        return redirect()->back();  
    }


    public function destroySelected(JobsRequest $request)
    {

       $agent = new Agent();
       $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
       $data = ['key'=>'dashboard_destroy_jobs_ids_['.json_encode($request->ids).']','text'=>'Destroy selected jobs Info','browser'=>$agent];

        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);

        if ($request->has('ids')) {
            $this->jobs->wherein('id',$request->ids)->delete();
        }else{
        $this->jobs->truncate();
        }
        Session::flash('success',trans('home.message_success'));
        return redirect()->back();  
    }


}
