<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Input;
use Illuminate\Database\Eloquent\SoftDeletes;

class Blog extends Model
{
    use SoftDeletes;
    protected $table = "blogs";
    protected $fillable  = [
                      
                        'url',
                        'meta_tags',
                        'image',
                        'status',
                            ];

    public function setUrlAttribute($url)
    {
        return  $this->attributes['url'] = str_replace(' ', '_', $url);
    }
   
   
    public function translations()
    {
        return $this->hasMany('App\BlogTranslation','blog_id');
    }
}
